/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.util;

import java.io.File;
import java.util.Date;
import java.util.Formatter;
import java.util.Locale;
import java.util.UUID;

public abstract class PathUtils {
    public static String format(String pathFormat, boolean appendUUID) {
        return PathUtils.format(pathFormat, appendUUID, new Date());
    }

    public static String format(String pathFormat) {
        return PathUtils.format(pathFormat, false);
    }

    public static String format(String pathFormat, Date date) {
        return PathUtils.format(pathFormat, false, date);
    }

    public static String format(String pathFormat, boolean appendUUID, Date date) {
        if (pathFormat == null || pathFormat.length() == 0) {
            return "";
        }
        pathFormat = pathFormat.replace('/', File.separatorChar);
        StringBuilder strBuffer = new StringBuilder();
        Formatter formatter = new Formatter(strBuffer, Locale.US);
        formatter.format(pathFormat, date);
        formatter.close();
        if (!pathFormat.endsWith(File.separator)) {
            strBuffer.append(File.separator);
        }
        if (appendUUID) {
            strBuffer.append(UUID.randomUUID());
            strBuffer.append(File.separator);
        }
        return strBuffer.toString();
    }
}

