/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.scripting;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleBindings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.data.hadoop.scripting.ScriptEvaluator;
import org.springframework.scripting.ScriptCompilationException;
import org.springframework.scripting.ScriptSource;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

class Jsr223ScriptEvaluator
implements ScriptEvaluator {
    private final Log log = LogFactory.getLog(this.getClass());
    private String language;
    private String extension;
    private ClassLoader classLoader;

    public Jsr223ScriptEvaluator() {
        this(null);
    }

    public Jsr223ScriptEvaluator(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    @Override
    public Object evaluate(ScriptSource script) {
        return this.evaluate(script, Collections.emptyMap());
    }

    @Override
    public Object evaluate(ScriptSource script, Map<String, Object> arguments) {
        ScriptEngine engine = this.discoverEngine(script, arguments);
        SimpleBindings bindings = !CollectionUtils.isEmpty(arguments) ? new SimpleBindings(arguments) : null;
        try {
            return bindings == null ? engine.eval(script.getScriptAsString()) : engine.eval(script.getScriptAsString(), (Bindings)bindings);
        }
        catch (IOException ex) {
            throw new ScriptCompilationException(script, "Cannot access script", (Throwable)ex);
        }
        catch (ScriptException ex) {
            throw new ScriptCompilationException(script, "Execution failure", (Throwable)ex);
        }
    }

    protected ScriptEngine discoverEngine(ScriptSource script, Map<String, Object> arguments) {
        ScriptEngineManager engineManager = new ScriptEngineManager(this.classLoader);
        ScriptEngine engine = null;
        if (StringUtils.hasText((String)this.language)) {
            engine = engineManager.getEngineByName(this.language);
        } else {
            Assert.hasText((String)this.extension, (String)"no language or extension specified");
            engine = engineManager.getEngineByExtension(this.extension);
        }
        Assert.notNull((Object)engine, (String)("No suitable engine found for " + (StringUtils.hasText((String)this.language) ? "language " + this.language : "extension " + this.extension)));
        if (this.log.isDebugEnabled()) {
            ScriptEngineFactory factory = engine.getFactory();
            this.log.debug((Object)String.format("Using ScriptEngine %s (%s), language %s (%s)", factory.getEngineName(), factory.getEngineVersion(), factory.getLanguageName(), factory.getLanguageVersion()));
        }
        return engine;
    }

    public void setExtension(String extension) {
        this.extension = extension;
    }

    public void setLanguage(String language) {
        this.language = language;
    }
}

