/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.Partitioner;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.hadoop.security.UserGroupInformation;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.hadoop.configuration.JobConfUtils;
import org.springframework.data.hadoop.mapreduce.ExecutionUtils;
import org.springframework.data.hadoop.mapreduce.JobGenericOptions;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class JobFactoryBean
extends JobGenericOptions
implements InitializingBean,
FactoryBean<Job>,
BeanNameAware,
BeanClassLoaderAware {
    private Job job;
    private Configuration configuration;
    private Properties properties;
    private String name;
    private String key;
    private String value;
    private String mapKey;
    private String mapValue;
    private String mapper;
    private String reducer;
    private String combiner;
    private String inputFormat;
    private String outputFormat;
    private String partitioner;
    private String sortComparator;
    private String groupingComparator;
    private String workingDir;
    private Integer numReduceTasks;
    private Class<?> jarClass;
    private Resource jar;
    private List<String> inputPaths;
    private String outputPath;
    private Boolean compressOutput;
    private String codecClass;
    private ClassLoader beanClassLoader;

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public Job getObject() throws Exception {
        return this.job;
    }

    public Class<?> getObjectType() {
        return this.job != null ? this.job.getClass() : Job.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void afterPropertiesSet() throws Exception {
        ClassLoader loader;
        JobConf cfg = JobConfUtils.createFrom(this.configuration, this.properties);
        this.buildGenericOptions((Configuration)cfg);
        if (StringUtils.hasText((String)this.user)) {
            UserGroupInformation ugi = UserGroupInformation.createProxyUser((String)this.user, (UserGroupInformation)UserGroupInformation.getLoginUser());
            ugi.doAs((PrivilegedExceptionAction)new PrivilegedExceptionAction<Void>((Configuration)cfg){
                final /* synthetic */ Configuration val$cfg;
                {
                    this.val$cfg = configuration;
                }

                @Override
                public Void run() throws Exception {
                    JobFactoryBean.this.job = new Job(this.val$cfg);
                    return null;
                }
            });
        } else {
            this.job = new Job((Configuration)cfg);
        }
        ClassLoader classLoader = loader = this.beanClassLoader != null ? this.beanClassLoader : ClassUtils.getDefaultClassLoader();
        if (this.jar != null) {
            JobConf conf = (JobConf)this.job.getConfiguration();
            conf.setJar(this.jar.getURI().toString());
            loader = ExecutionUtils.createParentLastClassLoader(this.jar, this.beanClassLoader, (Configuration)cfg);
            conf.setClassLoader(loader);
        }
        if (this.mapper != null) {
            Class<Mapper> mapperClass = this.resolveClass(this.mapper, loader, Mapper.class);
            this.job.setMapperClass(mapperClass);
            this.configureMapperTypesIfPossible(this.job, mapperClass);
        }
        if (this.reducer != null) {
            Class<Reducer> reducerClass = this.resolveClass(this.reducer, loader, Reducer.class);
            this.job.setReducerClass(reducerClass);
            this.configureReducerTypesIfPossible(this.job, reducerClass);
        }
        if (StringUtils.hasText((String)this.name)) {
            this.job.setJobName(this.name);
        }
        if (this.combiner != null) {
            this.job.setCombinerClass(this.resolveClass(this.combiner, loader, Reducer.class));
        }
        if (this.groupingComparator != null) {
            this.job.setGroupingComparatorClass(this.resolveClass(this.groupingComparator, loader, RawComparator.class));
        }
        if (this.inputFormat != null) {
            this.job.setInputFormatClass(this.resolveClass(this.inputFormat, loader, InputFormat.class));
        }
        if (this.mapKey != null) {
            this.job.setMapOutputKeyClass(this.resolveClass(this.mapKey, loader, Object.class));
        }
        if (this.mapValue != null) {
            this.job.setMapOutputValueClass(this.resolveClass(this.mapValue, loader, Object.class));
        }
        if (this.numReduceTasks != null) {
            this.job.setNumReduceTasks(this.numReduceTasks.intValue());
        }
        if (this.key != null) {
            this.job.setOutputKeyClass(this.resolveClass(this.key, loader, Object.class));
        }
        if (this.value != null) {
            this.job.setOutputValueClass(this.resolveClass(this.value, loader, Object.class));
        }
        if (this.outputFormat != null) {
            this.job.setOutputFormatClass(this.resolveClass(this.outputFormat, loader, OutputFormat.class));
        }
        if (this.partitioner != null) {
            this.job.setPartitionerClass(this.resolveClass(this.partitioner, loader, Partitioner.class));
        }
        if (this.sortComparator != null) {
            this.job.setSortComparatorClass(this.resolveClass(this.sortComparator, loader, RawComparator.class));
        }
        if (StringUtils.hasText((String)this.workingDir)) {
            this.job.setWorkingDirectory(new Path(this.workingDir));
        }
        if (this.jarClass != null) {
            this.job.setJarByClass(this.jarClass);
        }
        if (!CollectionUtils.isEmpty(this.inputPaths)) {
            for (String path : this.inputPaths) {
                FileInputFormat.addInputPath((Job)this.job, (Path)new Path(path));
            }
        }
        if (StringUtils.hasText((String)this.outputPath)) {
            FileOutputFormat.setOutputPath((Job)this.job, (Path)new Path(this.outputPath));
        }
        if (this.compressOutput != null) {
            FileOutputFormat.setCompressOutput((Job)this.job, (boolean)this.compressOutput);
        }
        if (this.codecClass != null) {
            FileOutputFormat.setOutputCompressorClass((Job)this.job, this.resolveClass(this.codecClass, loader, CompressionCodec.class));
        }
        this.processJob(this.job);
    }

    private <T> Class<? extends T> resolveClass(String className, ClassLoader cl, Class<T> type) {
        return ClassUtils.resolveClassName((String)className, (ClassLoader)cl);
    }

    private void configureMapperTypesIfPossible(Job j, Class<? extends Mapper> mapper) {
        Type[] params;
        Class<? extends Mapper> targetClass = mapper;
        Type targetType = mapper;
        do {
            targetType = targetClass.getGenericSuperclass();
        } while ((targetClass = targetClass.getSuperclass()) != null && targetClass != Object.class && !Mapper.class.equals(targetClass));
        if (targetType instanceof ParameterizedType && (params = ((ParameterizedType)targetType).getActualTypeArguments()).length == 4) {
            Class clz;
            if (params[2] instanceof Class && !(clz = (Class)params[2]).isInterface()) {
                j.setMapOutputKeyClass(clz);
            }
            if (params[3] instanceof Class && !(clz = (Class)params[3]).isInterface()) {
                j.setMapOutputValueClass(clz);
            }
        }
    }

    private void configureReducerTypesIfPossible(Job j, Class<? extends Reducer> reducer) {
    }

    private void validatePaths(String path, ResourcePatternResolver resourceLoader, boolean shouldExist) throws IOException {
        Resource res = resourceLoader.getResource(path);
        if (shouldExist) {
            Assert.isTrue((boolean)res.exists(), (String)("The input path [" + path + "] does not exist"));
        } else {
            Assert.isTrue((!res.exists() ? 1 : 0) != 0, (String)("The output path [" + path + "] already exists"));
        }
    }

    protected void processJob(Job job) throws Exception {
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setMapKey(String mapKey) {
        this.mapKey = mapKey;
    }

    public void setMapValue(String mapValue) {
        this.mapValue = mapValue;
    }

    public void setMapper(String mapper) {
        this.mapper = mapper;
    }

    public void setReducer(String reducer) {
        this.reducer = reducer;
    }

    public void setCombiner(String combiner) {
        this.combiner = combiner;
    }

    public void setInputFormat(String inputFormat) {
        this.inputFormat = inputFormat;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public void setPartitioner(String partitioner) {
        this.partitioner = partitioner;
    }

    public void setSortComparator(String sortComparator) {
        this.sortComparator = sortComparator;
    }

    public void setGroupingComparator(String groupingComparator) {
        this.groupingComparator = groupingComparator;
    }

    public void setWorkingDir(String workingDir) {
        this.workingDir = workingDir;
    }

    public void setNumberReducers(Integer numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public void setJarByClass(Class<?> jarClass) {
        this.jarClass = jarClass;
    }

    public void setJar(Resource jar) {
        this.jar = jar;
    }

    public void setInputPath(String ... inputPath) {
        if (inputPath != null && inputPath.length == 1) {
            inputPath = StringUtils.commaDelimitedListToStringArray((String)inputPath[0]);
        }
        this.inputPaths = Arrays.asList(inputPath);
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }

    public void setCompressOutput(Boolean compressOutput) {
        this.compressOutput = compressOutput;
    }

    public void setCodec(String codecClass) {
        this.codecClass = codecClass;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

