/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapreduce.Job;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.task.SyncTaskExecutor;
import org.springframework.data.hadoop.mapreduce.JobUtils;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class JobExecutor
implements InitializingBean,
DisposableBean,
BeanFactoryAware {
    private Collection<Job> jobs;
    private Iterable<String> jobNames;
    private boolean waitForCompletion = true;
    private boolean killJobsAtShutdown = true;
    private BeanFactory beanFactory;
    private boolean verbose = true;
    private Executor taskExecutor = new SyncTaskExecutor();
    private volatile boolean shuttingDown = false;
    private Collection<Job> recentJobs = Collections.emptyList();
    protected Log log = LogFactory.getLog(this.getClass());

    public void afterPropertiesSet() throws Exception {
        Assert.isTrue((boolean)(this.jobs != null | this.jobNames != null), (String)"A Hadoop job or its name is required");
        if (this.jobNames != null) {
            for (String jobName : this.jobNames) {
                if (!StringUtils.hasText((String)jobName)) continue;
                Assert.notNull((Object)this.beanFactory, (String)"a bean factory is required if the job is specified by name");
                Assert.isTrue((boolean)this.beanFactory.containsBean(jobName), (String)("beanFactory does not contain any bean named [" + this.jobNames + "]"));
            }
        }
        if (this.isWaitForCompletion()) {
            this.setKillJobAtShutdown(true);
        }
    }

    public void destroy() throws Exception {
        if (this.isWaitForCompletion() || this.isKillJobsAtShutdown()) {
            this.stopJobs();
        }
    }

    protected Collection<Job> stopJobs() {
        return this.stopJobs(null);
    }

    protected Collection<Job> stopJobs(final JobListener listener) {
        this.shuttingDown = true;
        final Collection<Job> jbs = this.findJobs();
        final ArrayList killedJobs = new ArrayList();
        this.taskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                Object listenerInit = null;
                if (listener != null) {
                    listenerInit = listener.beforeAction();
                }
                try {
                    for (Job job : jbs) {
                        try {
                            if (!JobUtils.getStatus(job).isRunning()) continue;
                            List list = killedJobs;
                            synchronized (list) {
                                killedJobs.add(job);
                            }
                            JobExecutor.this.log.info((Object)("Killing job [" + job.getJobName() + "]"));
                            job.killJob();
                            if (listener == null) continue;
                            listener.jobKilled(job);
                        }
                        catch (Exception ex) {
                            JobExecutor.this.log.warn((Object)("Cannot kill job [" + job.getJobName() + "]"), (Throwable)ex);
                            if (!RuntimeException.class.isAssignableFrom(ex.getClass())) throw new IllegalStateException(ex);
                            throw (RuntimeException)ex;
                            return;
                        }
                    }
                }
                finally {
                    if (listener != null) {
                        listener.afterAction(listenerInit);
                    }
                }
            }
        });
        return jbs;
    }

    protected Collection<Job> startJobs() {
        return this.startJobs(null);
    }

    protected Collection<Job> startJobs(final JobListener listener) {
        final Collection<Job> jbs = this.findJobs();
        final ArrayList<Job> started = new ArrayList<Job>();
        this.taskExecutor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object listenerInit = null;
                if (listener != null) {
                    listenerInit = listener.beforeAction();
                }
                try {
                    for (Job job : jbs) {
                        boolean succes = false;
                        try {
                            if (JobUtils.getStatus(job).isStarted()) {
                                JobExecutor.this.log.info((Object)("Job [" + job.getJobName() + "] already started; skipping it..."));
                                break;
                            }
                            JobExecutor.this.log.info((Object)("Starting job [" + job.getJobName() + "]"));
                            List list = started;
                            synchronized (list) {
                                started.add(job);
                            }
                            if (!JobExecutor.this.waitForCompletion) {
                                succes = true;
                                job.submit();
                            } else {
                                succes = job.waitForCompletion(JobExecutor.this.verbose);
                                JobExecutor.this.log.info((Object)("Completed job [" + job.getJobName() + "]"));
                                if (listener != null) {
                                    listener.jobFinished(job);
                                }
                            }
                        }
                        catch (InterruptedException ex) {
                            JobExecutor.this.log.warn((Object)("Job [" + job.getJobName() + "] killed"));
                            throw new IllegalStateException(ex);
                        }
                        catch (Exception ex) {
                            JobExecutor.this.log.warn((Object)("Cannot start job [" + job.getJobName() + "]"), (Throwable)ex);
                            throw new IllegalStateException(ex);
                        }
                        if (succes) continue;
                        if (!JobExecutor.this.shuttingDown) {
                            JobUtils.JobStatus status = JobUtils.getStatus(job);
                            if (JobUtils.JobStatus.KILLED == status) {
                                throw new IllegalStateException("Job " + job.getJobName() + "] killed");
                            }
                            throw new IllegalStateException("Job " + job.getJobName() + "] failed to start; status=" + (Object)((Object)status));
                        }
                        JobExecutor.this.log.info((Object)("Job [" + job.getJobName() + "] killed by shutdown"));
                    }
                }
                finally {
                    if (listener != null) {
                        listener.afterAction(listenerInit);
                    }
                }
            }
        });
        return started;
    }

    protected Collection<Job> findJobs() {
        Collection<Job> js = null;
        if (this.jobs != null) {
            js = this.jobs;
        } else {
            if (this.shuttingDown) {
                return this.recentJobs;
            }
            js = new ArrayList<Job>();
            for (String name : this.jobNames) {
                js.add((Job)this.beanFactory.getBean(name, Job.class));
            }
        }
        this.recentJobs = js;
        return js;
    }

    public void setJob(Job job) {
        this.jobs = Collections.singleton(job);
    }

    public void setJobs(Collection<Job> jobs) {
        this.jobs = jobs;
    }

    public void setJobNames(String ... jobName) {
        this.jobNames = Arrays.asList(jobName);
    }

    public boolean isWaitForCompletion() {
        return this.waitForCompletion;
    }

    public void setWaitForCompletion(boolean waitForJob) {
        this.waitForCompletion = waitForJob;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setExecutor(Executor executor) {
        Assert.notNull((Object)executor, (String)"a non-null task executor is required");
        this.taskExecutor = executor;
    }

    public boolean isKillJobsAtShutdown() {
        return this.killJobsAtShutdown;
    }

    public void setKillJobAtShutdown(boolean killJobsAtShutdown) {
        this.killJobsAtShutdown = killJobsAtShutdown;
    }

    protected static interface JobListener {
        public Object beforeAction();

        public void afterAction(Object var1);

        public void jobFinished(Job var1);

        public void jobKilled(Job var1);
    }
}

