/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.mapreduce;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.Permission;
import java.security.Policy;
import java.security.Security;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import javax.imageio.ImageIO;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.mapred.Counters;
import org.springframework.core.io.Resource;
import org.springframework.data.hadoop.mapreduce.ParentLastURLClassLoader;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

abstract class ExecutionUtils {
    private static final Log log = LogFactory.getLog(ExecutionUtils.class);
    private static Field CLASS_CACHE = ReflectionUtils.findField(Configuration.class, (String)"CACHE_CLASS");
    private static Method UTILS_CONSTRUCTOR_CACHE;
    private static final Set<String> JVM_THREAD_NAMES;
    private static SecurityManager oldSM;

    ExecutionUtils() {
    }

    static void disableSystemExitCall() {
        SecurityManager securityManager = new SecurityManager(){

            @Override
            public void checkPermission(Permission permission) {
                String name = permission.getName();
                if (name.startsWith("exitVM")) {
                    throw new ExitTrapped(name);
                }
            }
        };
        oldSM = System.getSecurityManager();
        System.setSecurityManager(securityManager);
    }

    static void enableSystemExitCall() {
        System.setSecurityManager(oldSM);
    }

    static ClassLoader createParentLastClassLoader(Resource jar, ClassLoader parentClassLoader, Configuration cfg) {
        ClassLoader cl = null;
        if (parentClassLoader == null) {
            cl = parentClassLoader = ClassUtils.getDefaultClassLoader();
        }
        if (jar != null) {
            try {
                if (ExecutionUtils.isLegacyJar(jar)) {
                    URL[] extractedURLs = ExecutionUtils.expandedJarClassPath(jar, cfg);
                    cl = new ParentLastURLClassLoader(extractedURLs, parentClassLoader);
                } else {
                    cl = new ParentLastURLClassLoader(new URL[]{jar.getURL()}, parentClassLoader);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Cannot open jar file", e);
            }
        }
        return cl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isLegacyJar(Resource jar) throws IOException {
        JarInputStream jis = new JarInputStream(jar.getInputStream());
        JarEntry entry = null;
        try {
            while ((entry = jis.getNextJarEntry()) != null) {
                String name = entry.getName();
                if (!name.startsWith("lib/")) continue;
                boolean bl = true;
                return bl;
            }
        }
        finally {
            IOUtils.closeStream((Closeable)jis);
        }
        return false;
    }

    private static URL[] expandedJarClassPath(Resource jar, Configuration cfg) throws IOException {
        File baseDir = ExecutionUtils.detectBaseDir(cfg);
        ExecutionUtils.unjar(jar, baseDir);
        ArrayList<URL> cp = new ArrayList<URL>();
        cp.add(new File(baseDir + "/").toURI().toURL());
        File[] libs = new File(baseDir, "lib").listFiles();
        if (libs != null) {
            for (int i = 0; i < libs.length; ++i) {
                cp.add(libs[i].toURI().toURL());
            }
        }
        return cp.toArray(new URL[cp.size()]);
    }

    private static File detectBaseDir(Configuration cfg) throws IOException {
        File tmpDir = null;
        if (cfg != null) {
            tmpDir = new File(cfg.get("hadoop.tmp.dir"));
            tmpDir.mkdirs();
            if (!tmpDir.isDirectory()) {
                tmpDir = null;
            }
        }
        File workDir = File.createTempFile("hadoop-unjar", "", tmpDir);
        workDir.delete();
        workDir.mkdirs();
        return workDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void unjar(Resource jar, File baseDir) throws IOException {
        JarInputStream jis = new JarInputStream(jar.getInputStream());
        JarEntry entry = null;
        try {
            while ((entry = jis.getNextJarEntry()) != null) {
                if (entry.isDirectory()) continue;
                File file = new File(baseDir, entry.getName());
                if (!file.getParentFile().mkdirs() && !file.getParentFile().isDirectory()) {
                    throw new IOException("Mkdirs failed to create " + file.getParentFile().toString());
                }
                FileOutputStream out = new FileOutputStream(file);
                try {
                    int i;
                    byte[] buffer = new byte[8192];
                    while ((i = jis.read(buffer)) != -1) {
                        ((OutputStream)out).write(buffer, 0, i);
                    }
                }
                finally {
                    IOUtils.closeStream((Closeable)out);
                }
            }
        }
        finally {
            IOUtils.closeStream((Closeable)jis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String mainClass(Resource jar) throws IOException {
        JarInputStream jis = new JarInputStream(jar.getInputStream());
        try {
            String main;
            Manifest mf = jis.getManifest();
            if (mf != null && StringUtils.hasText((String)(main = mf.getMainAttributes().getValue("Main-Class")))) {
                String string = main.replace("/", ".");
                return string;
            }
            String string = null;
            return string;
        }
        finally {
            IOUtils.closeStream((Closeable)jis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void preventJreTcclLeaks() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Preventing JRE TCCL leaks");
        }
        ClassLoader sysLoader = ClassLoader.getSystemClassLoader();
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(sysLoader);
            ClassUtils.resolveClassName((String)"javax.security.auth.Policy", (ClassLoader)sysLoader);
            Policy.getPolicy();
            try {
                javax.security.auth.login.Configuration.getInstance(null, null, (String)null);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Security.getProviders();
            DriverManager.getDrivers();
            ImageIO.getCacheDirectory();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void preventHadoopLeaks(ClassLoader hadoopCL) {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            new Counters();
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    static void patchLeakedClassLoader(ClassLoader leakedClassLoader, ClassLoader replacementClassLoader) {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Patching TCCL leaks");
        }
        ExecutionUtils.replaceTccl(leakedClassLoader, replacementClassLoader);
        ExecutionUtils.fixHadoopReflectionUtilsLeak(leakedClassLoader);
        ExecutionUtils.fixHadoopReflectionUtilsLeak();
        ExecutionUtils.cleanHadoopLocalDirAllocator();
    }

    private static void cleanHadoopLocalDirAllocator() {
        Field field = ReflectionUtils.findField(LocalDirAllocator.class, (String)"contexts");
        ReflectionUtils.makeAccessible((Field)field);
        Map contexts = (Map)ReflectionUtils.getField((Field)field, null);
        if (contexts != null) {
            contexts.clear();
        }
    }

    private static void fixHadoopReflectionUtilsLeak(ClassLoader leakedClassLoader) {
        if (CLASS_CACHE == null) {
            return;
        }
        Map cache = (Map)ReflectionUtils.getField((Field)CLASS_CACHE, null);
        cache.remove(leakedClassLoader);
    }

    private static void fixHadoopReflectionUtilsLeak() {
        ReflectionUtils.invokeMethod((Method)UTILS_CONSTRUCTOR_CACHE, null);
    }

    private static void replaceTccl(ClassLoader leakedClassLoader, ClassLoader replacementClassLoader) {
        for (Thread thread : ExecutionUtils.threads()) {
            ClassLoader cl;
            if (thread == null || leakedClassLoader != (cl = thread.getContextClassLoader())) continue;
            log.warn((Object)("Trying to patch leaked cl [" + leakedClassLoader + "] in thread [" + thread + "]"));
            ThreadGroup tg = thread.getThreadGroup();
            boolean debug = log.isDebugEnabled();
            if (tg != null && JVM_THREAD_NAMES.contains(tg.getName())) {
                thread.setContextClassLoader(ClassLoader.getSystemClassLoader());
                if (!debug) continue;
                log.debug((Object)("Replaced leaked cl in thread [" + thread + "] with system classloader"));
                continue;
            }
            thread.setContextClassLoader(replacementClassLoader);
            if (!debug) continue;
            log.debug((Object)("Replaced leaked cl in thread [" + thread + "] with " + replacementClassLoader));
        }
    }

    static void shutdownFileSystem(Configuration cfg) {
        FileSystem fs;
        try {
            fs = FileSystem.get((Configuration)cfg);
            if (fs != null) {
                fs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fs = FileSystem.getLocal((Configuration)cfg);
            if (fs != null) {
                fs.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static Thread[] threads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while (tg.getParent() != null) {
            tg = tg.getParent();
        }
        int threadCountGuess = tg.activeCount() + 50;
        Thread[] threads = new Thread[threadCountGuess];
        int threadCountActual = tg.enumerate(threads);
        while (threadCountActual == threadCountGuess) {
            threads = new Thread[threadCountGuess *= 2];
            threadCountActual = tg.enumerate(threads);
        }
        return threads;
    }

    static void earlyLeaseDaemonInit(Configuration config) throws IOException {
        ClassLoader cl = config.getClassLoader();
        if (cl instanceof ParentLastURLClassLoader) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Preventing DFS LeaseDaemon TCCL leak");
            }
            FileSystem fs = FileSystem.get((Configuration)config);
            Thread.currentThread().setContextClassLoader(ClassLoader.getSystemClassLoader());
            Path p = new Path("/tmp/shdp-lease-early-init-" + UUID.randomUUID().toString());
            fs.create(p).close();
            fs.delete(p, false);
        }
    }

    static {
        if (CLASS_CACHE != null) {
            ReflectionUtils.makeAccessible((Field)CLASS_CACHE);
        }
        UTILS_CONSTRUCTOR_CACHE = ReflectionUtils.findMethod(org.apache.hadoop.util.ReflectionUtils.class, (String)"clearCache");
        ReflectionUtils.makeAccessible((Method)UTILS_CONSTRUCTOR_CACHE);
        JVM_THREAD_NAMES = new HashSet<String>();
        JVM_THREAD_NAMES.add("system");
        JVM_THREAD_NAMES.add("RMI Runtime");
        oldSM = null;
    }

    static class ExitTrapped
    extends Error {
        private int exitCode;

        ExitTrapped(String permissionName) {
            int hasDot = permissionName.indexOf(".");
            this.exitCode = Integer.valueOf(hasDot > 0 ? permissionName.substring(hasDot + 1) : permissionName.substring(7));
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

