/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.compress.CompressionCodecFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.PriorityOrdered;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.data.hadoop.fs.HdfsResource;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class HdfsResourceLoader
extends DefaultResourceLoader
implements ResourcePatternResolver,
PriorityOrdered,
Closeable,
DisposableBean,
InitializingBean {
    private static final Log log = LogFactory.getLog(HdfsResourceLoader.class);
    private static final String HDFS_URL_PREFIX = "hdfs:";
    private final FileSystem fs;
    private final PathMatcher pathMatcher = new AntPathMatcher();
    private final boolean internalFS;
    private volatile boolean useCodecs = true;
    private volatile CompressionCodecFactory codecsFactory;
    private volatile boolean handleNoprefix = true;
    private String impersonatedUser = null;
    private ResourcePatternResolver resourcePatternResolver;

    public HdfsResourceLoader(Configuration config) {
        this(config, null);
    }

    public HdfsResourceLoader(Configuration config, URI uri, String user) {
        Assert.notNull((Object)config, (String)"a valid configuration is required");
        this.impersonatedUser = user;
        this.internalFS = true;
        FileSystem tempFS = null;
        this.codecsFactory = new CompressionCodecFactory(config);
        try {
            if (uri == null) {
                uri = FileSystem.getDefaultUri((Configuration)config);
            }
            tempFS = StringUtils.hasText((String)this.impersonatedUser) ? FileSystem.get((URI)uri, (Configuration)config, (String)this.impersonatedUser) : FileSystem.get((URI)uri, (Configuration)config);
        }
        catch (Exception ex) {
            tempFS = null;
            throw new IllegalStateException("Cannot create filesystem", ex);
        }
        finally {
            this.fs = tempFS;
        }
    }

    public HdfsResourceLoader(Configuration config, URI uri) {
        this(config, uri, null);
    }

    public HdfsResourceLoader(FileSystem fs) {
        Assert.notNull((Object)fs, (String)"a non-null file-system required");
        this.fs = fs;
        this.internalFS = false;
        this.codecsFactory = new CompressionCodecFactory(fs.getConf());
    }

    protected Resource getResourceByPath(String path) {
        if (this.handleNoprefix) {
            return new HdfsResource(this.stripLeadingTilde(path), this.fs, this.codecs());
        }
        return super.getResourceByPath(path);
    }

    public Resource getResource(String location) {
        if (location.startsWith(HDFS_URL_PREFIX) || location.indexOf(58) < 0 && this.handleNoprefix) {
            return this.getResourceByPath(location);
        }
        return super.getResource(location);
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Assert.notNull((Object)locationPattern, (String)"Location pattern must not be null");
        if (locationPattern.startsWith(HDFS_URL_PREFIX) || locationPattern.indexOf(58) < 0 && this.handleNoprefix) {
            if (this.pathMatcher.isPattern(HdfsResourceLoader.stripPrefix(locationPattern))) {
                return this.findPathMatchingResources(locationPattern);
            }
            return new Resource[]{this.getResource(HdfsResourceLoader.stripPrefix(this.stripLeadingTilde(locationPattern)))};
        }
        return this.resourcePatternResolver.getResources(locationPattern);
    }

    public int getOrder() {
        return Integer.MIN_VALUE;
    }

    public void destroy() throws IOException {
        this.close();
    }

    @Override
    public void close() throws IOException {
        if (this.fs != null && this.internalFS) {
            try {
                this.fs.close();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.resourcePatternResolver == null) {
            this.resourcePatternResolver = new PathMatchingResourcePatternResolver((ResourceLoader)this);
        }
    }

    public ClassLoader getClassLoader() {
        return this.fs.getConf().getClassLoader();
    }

    public void setHandleNoprefix(boolean handleNoprefix) {
        this.handleNoprefix = handleNoprefix;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public void setUseCodecs(boolean useCodecs) {
        this.useCodecs = useCodecs;
    }

    public void setResourcePatternResolver(ResourcePatternResolver resourcePatternResolver) {
        this.resourcePatternResolver = resourcePatternResolver;
    }

    protected Resource[] findPathMatchingResources(String locationPattern) throws IOException {
        String rootDirPath = this.determineRootDir(locationPattern);
        String subPattern = locationPattern.substring(rootDirPath.length());
        Resource[] rootDirResources = this.getResources(rootDirPath);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(16);
        for (Resource rootDirResource : rootDirResources) {
            result.addAll(this.doFindPathMatchingFileResources(rootDirResource, subPattern));
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Resolved location pattern [" + locationPattern + "] to resources " + result));
        }
        return result.toArray(new Resource[result.size()]);
    }

    protected Set<Resource> doFindPathMatchingFileResources(Resource rootDirResource, String subPattern) throws IOException {
        Path rootDir;
        try {
            rootDir = rootDirResource instanceof HdfsResource ? ((HdfsResource)rootDirResource).getPath() : new Path(rootDirResource.getURI().toString());
        }
        catch (IOException ex) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Cannot search for matching files underneath " + rootDirResource + " because it does not correspond to a directory in the file system"), (Throwable)ex);
            }
            return Collections.emptySet();
        }
        return this.doFindMatchingFileSystemResources(rootDir, subPattern);
    }

    protected Set<Resource> doFindMatchingFileSystemResources(Path rootDir, String subPattern) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Looking for matching resources in directory tree [" + rootDir.toUri().getPath() + "]"));
        }
        Set<Path> matchingFiles = this.retrieveMatchingFiles(rootDir, subPattern);
        LinkedHashSet<Resource> result = new LinkedHashSet<Resource>(matchingFiles.size());
        for (Path path : matchingFiles) {
            result.add((Resource)new HdfsResource(path, this.fs, this.codecs()));
        }
        return result;
    }

    protected Set<Path> retrieveMatchingFiles(Path rootDir, String pattern) throws IOException {
        boolean exists = this.fs.exists(rootDir);
        if (!exists) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Skipping [" + rootDir.toUri().getPath() + "] because it does not exist"));
            }
            return Collections.emptySet();
        }
        FileStatus fileStatus = this.fs.getFileStatus(rootDir);
        if (!fileStatus.isDir()) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Skipping [" + rootDir.toUri().getPath() + "] because it does not denote a directory"));
            }
            return Collections.emptySet();
        }
        String fullPattern = StringUtils.replace((String)rootDir.toUri().getPath(), (String)File.separator, (String)"/");
        if (!pattern.startsWith("/")) {
            fullPattern = fullPattern + "/";
        }
        fullPattern = fullPattern + StringUtils.replace((String)pattern, (String)File.separator, (String)"/");
        LinkedHashSet<Path> result = new LinkedHashSet<Path>(8);
        this.doRetrieveMatchingFiles(fullPattern, rootDir, result);
        return result;
    }

    protected void doRetrieveMatchingFiles(String fullPattern, Path dir, Set<Path> result) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Searching directory [" + dir.toUri().getPath() + "] for files matching pattern [" + fullPattern + "]"));
        }
        FileStatus[] dirContents = null;
        try {
            dirContents = this.fs.listStatus(dir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (dirContents == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Could not retrieve contents of directory [" + dir.toUri().getPath() + "]"));
            }
            return;
        }
        for (FileStatus content : dirContents) {
            String currPath = StringUtils.replace((String)content.getPath().toUri().getPath(), (String)File.separator, (String)"/");
            if (content.isDir() && this.pathMatcher.matchStart(fullPattern, currPath + "/")) {
                this.doRetrieveMatchingFiles(fullPattern, content.getPath(), result);
            }
            if (!this.pathMatcher.match(fullPattern, currPath)) continue;
            result.add(content.getPath());
        }
    }

    protected String determineRootDir(String location) {
        int rootDirEnd = location.length();
        while (rootDirEnd > 0 && this.pathMatcher.isPattern(location.substring(0, rootDirEnd))) {
            rootDirEnd = location.lastIndexOf(47, rootDirEnd - 2) + 1;
        }
        return location.substring(0, rootDirEnd);
    }

    private String stripLeadingTilde(String locationPattern) {
        if (locationPattern.startsWith("~/")) {
            return locationPattern.substring(2);
        }
        return locationPattern;
    }

    private CompressionCodecFactory codecs() {
        return this.useCodecs ? this.codecsFactory : null;
    }

    private static String stripPrefix(String path) {
        String ret = null;
        try {
            ret = new Path(path).toUri().getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (ret == null && path.startsWith(HDFS_URL_PREFIX) && !path.startsWith("hdfs://")) {
            ret = path.substring(5);
        }
        if (ret == null) {
            ret = path;
        }
        return ret;
    }
}

