/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.hadoop.fs;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedList;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.springframework.beans.BeanUtils;
import org.springframework.data.hadoop.HadoopException;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

abstract class FsShellPermissions {
    FsShellPermissions() {
    }

    static <T> T[] concatAll(T[] first, T[] ... rest) {
        int totalLength = first.length;
        for (T[] array : rest) {
            totalLength += array.length;
        }
        T[] result = Arrays.copyOf(first, totalLength);
        int offset = first.length;
        for (T[] array : rest) {
            System.arraycopy(array, 0, result, offset, array.length);
            offset += array.length;
        }
        return result;
    }

    static void changePermissions(FileSystem fs, Configuration config, Op op, boolean recursive, String group, String ... uris) {
        Object[] argvs = new String[]{};
        if (recursive) {
            ObjectUtils.addObjectToArray((Object[])argvs, (Object)"-R");
        }
        argvs = FsShellPermissions.concatAll(argvs, {group}, uris);
        Class cmd = ClassUtils.resolveClassName((String)"org.apache.hadoop.fs.shell.Command", (ClassLoader)config.getClass().getClassLoader());
        Class targetClz = null;
        switch (op) {
            case CHOWN: {
                targetClz = ClassUtils.resolveClassName((String)"org.apache.hadoop.fs.FsShellPermissions$Chown", (ClassLoader)config.getClass().getClassLoader());
                break;
            }
            case CHGRP: {
                targetClz = ClassUtils.resolveClassName((String)"org.apache.hadoop.fs.FsShellPermissions$Chgrp", (ClassLoader)config.getClass().getClassLoader());
                break;
            }
            case CHMOD: {
                targetClz = ClassUtils.resolveClassName((String)"org.apache.hadoop.fs.FsShellPermissions$Chmod", (ClassLoader)config.getClass().getClassLoader());
                break;
            }
            default: {
                throw new IllegalArgumentException((Object)((Object)op) + " is not a valid FsShell operation for FsShellPermissions");
            }
        }
        Configurable target = (Configurable)BeanUtils.instantiate((Class)targetClz);
        target.setConf(config);
        LinkedList<Object> args = new LinkedList<Object>(Arrays.asList(argvs));
        try {
            Method m = ReflectionUtils.findMethod((Class)cmd, (String)"processOptions", (Class[])new Class[]{LinkedList.class});
            ReflectionUtils.makeAccessible((Method)m);
            ReflectionUtils.invokeMethod((Method)m, (Object)target, (Object[])new Object[]{args});
            m = ReflectionUtils.findMethod((Class)cmd, (String)"processRawArguments", (Class[])new Class[]{LinkedList.class});
            ReflectionUtils.makeAccessible((Method)m);
            ReflectionUtils.invokeMethod((Method)m, (Object)target, (Object[])new Object[]{args});
        }
        catch (IllegalStateException ex) {
            throw new HadoopException("Cannot change permissions/ownership " + ex);
        }
    }

    static enum Op {
        CHOWN("-chown"),
        CHMOD("-chmod"),
        CHGRP("-chgrp");

        private final String cmd;

        private Op(String cmd) {
            this.cmd = cmd;
        }

        public String getCmd() {
            return this.cmd;
        }
    }
}

