/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.env.Environment;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.SpringFactoriesLoader;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.data.config.ParsingUtils;
import org.springframework.data.repository.config.CustomRepositoryImplementationDetector;
import org.springframework.data.repository.config.FragmentMetadata;
import org.springframework.data.repository.config.ImplementationDetectionConfiguration;
import org.springframework.data.repository.config.ImplementationLookupConfiguration;
import org.springframework.data.repository.config.NamedQueriesBeanDefinitionBuilder;
import org.springframework.data.repository.config.RepositoryConfiguration;
import org.springframework.data.repository.config.RepositoryConfigurationAdapter;
import org.springframework.data.repository.config.RepositoryConfigurationExtension;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryFragmentConfiguration;
import org.springframework.data.repository.core.support.RepositoryFragment;
import org.springframework.data.repository.core.support.RepositoryFragmentsFactoryBean;
import org.springframework.data.util.Optionals;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

class RepositoryBeanDefinitionBuilder {
    private static final Log logger = LogFactory.getLog(RepositoryBeanDefinitionBuilder.class);
    private final BeanDefinitionRegistry registry;
    private final RepositoryConfigurationExtension extension;
    private final ResourceLoader resourceLoader;
    private final MetadataReaderFactory metadataReaderFactory;
    private final FragmentMetadata fragmentMetadata;
    private final CustomRepositoryImplementationDetector implementationDetector;
    private final RepositoryFactoriesLoader factoriesLoader;

    public RepositoryBeanDefinitionBuilder(BeanDefinitionRegistry registry, RepositoryConfigurationExtension extension, RepositoryConfigurationSource configurationSource, ResourceLoader resourceLoader, Environment environment) {
        Assert.notNull((Object)extension, (String)"RepositoryConfigurationExtension must not be null");
        Assert.notNull((Object)resourceLoader, (String)"ResourceLoader must not be null");
        Assert.notNull((Object)environment, (String)"Environment must not be null");
        this.registry = registry;
        this.extension = extension;
        this.resourceLoader = resourceLoader;
        this.factoriesLoader = RepositoryFactoriesLoader.forDefaultResourceLocation(resourceLoader.getClassLoader());
        this.metadataReaderFactory = new CachingMetadataReaderFactory(resourceLoader);
        this.fragmentMetadata = new FragmentMetadata(this.metadataReaderFactory);
        this.implementationDetector = new CustomRepositoryImplementationDetector(environment, resourceLoader, configurationSource.toImplementationDetectionConfiguration(this.metadataReaderFactory));
    }

    public BeanDefinitionBuilder build(RepositoryConfiguration<?> configuration) {
        Assert.notNull((Object)this.registry, (String)"BeanDefinitionRegistry must not be null");
        Assert.notNull((Object)this.resourceLoader, (String)"ResourceLoader must not be null");
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition((String)configuration.getRepositoryFactoryBeanClassName());
        builder.getRawBeanDefinition().setSource(configuration.getSource());
        builder.addConstructorArgValue((Object)configuration.getRepositoryInterface());
        builder.addPropertyValue("queryLookupStrategyKey", configuration.getQueryLookupStrategyKey());
        builder.addPropertyValue("lazyInit", (Object)configuration.isLazyInit());
        builder.setLazyInit(configuration.isLazyInit());
        builder.setPrimary(configuration.isPrimary());
        configuration.getRepositoryBaseClassName().ifPresent(it -> builder.addPropertyValue("repositoryBaseClass", it));
        NamedQueriesBeanDefinitionBuilder definitionBuilder = new NamedQueriesBeanDefinitionBuilder(this.extension.getDefaultNamedQueryLocation());
        configuration.getNamedQueriesLocation().ifPresent(definitionBuilder::setLocations);
        String namedQueriesBeanName = BeanDefinitionReaderUtils.uniqueBeanName((String)(this.extension.getModuleIdentifier() + ".named-queries"), (BeanDefinitionRegistry)this.registry);
        BeanDefinition namedQueries = definitionBuilder.build(configuration.getSource());
        this.registry.registerBeanDefinition(namedQueriesBeanName, namedQueries);
        builder.addPropertyValue("namedQueries", (Object)new RuntimeBeanReference(namedQueriesBeanName));
        this.registerCustomImplementation(configuration).ifPresent(it -> {
            builder.addPropertyReference("customImplementation", it);
            builder.addDependsOn(it);
        });
        String fragmentsBeanName = this.registerRepositoryFragments(configuration);
        builder.addPropertyValue("repositoryFragments", (Object)new RuntimeBeanReference(fragmentsBeanName));
        return builder;
    }

    RepositoryConfigurationAdapter<?> buildMetadata(RepositoryConfiguration<?> configuration) {
        ImplementationLookupConfiguration lookup;
        Optional<AbstractBeanDefinition> beanDefinition;
        ImplementationDetectionConfiguration config = configuration.toImplementationDetectionConfiguration(this.metadataReaderFactory);
        List<RepositoryFragmentConfiguration> repositoryFragmentConfigurationStream = this.fragmentMetadata.getFragmentInterfaces(configuration.getRepositoryInterface()).map(it -> this.detectRepositoryFragmentConfiguration((String)it, config, configuration)).flatMap(xva$0 -> Optionals.toStream(xva$0)).toList();
        if (repositoryFragmentConfigurationStream.isEmpty() && (beanDefinition = this.implementationDetector.detectCustomImplementation(lookup = configuration.toLookupConfiguration(this.metadataReaderFactory))).isPresent()) {
            repositoryFragmentConfigurationStream = new ArrayList<RepositoryFragmentConfiguration>(1);
            List<String> interfaceNames = this.fragmentMetadata.getFragmentInterfaces(configuration.getRepositoryInterface()).toList();
            String implClassName = beanDefinition.get().getBeanClassName();
            try {
                for (String iName : this.metadataReaderFactory.getMetadataReader(implClassName).getClassMetadata().getInterfaceNames()) {
                    if (!interfaceNames.contains(iName)) continue;
                    repositoryFragmentConfigurationStream.add(new RepositoryFragmentConfiguration(iName, implClassName));
                    break;
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        return new RepositoryConfigurationAdapter(configuration, repositoryFragmentConfigurationStream);
    }

    private Optional<String> registerCustomImplementation(RepositoryConfiguration<?> configuration) {
        ImplementationLookupConfiguration lookup = configuration.toLookupConfiguration(this.metadataReaderFactory);
        String configurationBeanName = lookup.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(configurationBeanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Custom repository implementation already registered: %s", configurationBeanName));
            }
            return Optional.of(configurationBeanName);
        }
        return this.implementationDetector.detectCustomImplementation(lookup).map(it -> this.potentiallyRegisterRepositoryImplementation(configuration, (AbstractBeanDefinition)it));
    }

    private String registerRepositoryFragments(RepositoryConfiguration<?> configuration) {
        BeanDefinitionBuilder fragmentsBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragmentsFactoryBean.class).setRole(2);
        List fragmentBeanNames = this.registerRepositoryFragmentsImplementation(configuration).map(RepositoryFragmentConfiguration::getFragmentBeanName).collect(Collectors.toList());
        fragmentsBuilder.addConstructorArgValue(fragmentBeanNames);
        String fragmentsBeanName = BeanDefinitionReaderUtils.uniqueBeanName((String)String.format("%s.%s.fragments", this.extension.getModuleName().toLowerCase(Locale.ROOT), ClassUtils.getShortName((String)configuration.getRepositoryInterface())), (BeanDefinitionRegistry)this.registry);
        this.registry.registerBeanDefinition(fragmentsBeanName, (BeanDefinition)fragmentsBuilder.getBeanDefinition());
        return fragmentsBeanName;
    }

    private Stream<RepositoryFragmentConfiguration> registerRepositoryFragmentsImplementation(RepositoryConfiguration<?> configuration) {
        ImplementationDetectionConfiguration config = configuration.toImplementationDetectionConfiguration(this.metadataReaderFactory);
        Stream<RepositoryFragmentConfiguration> discovered = this.discoverFragments(configuration, config);
        Stream<RepositoryFragmentConfiguration> loaded = this.loadFragments(configuration);
        return Stream.concat(discovered, loaded).peek(it -> this.potentiallyRegisterFragmentImplementation(configuration, (RepositoryFragmentConfiguration)it)).peek(it -> this.potentiallyRegisterRepositoryFragment(configuration, (RepositoryFragmentConfiguration)it));
    }

    private Stream<RepositoryFragmentConfiguration> discoverFragments(RepositoryConfiguration<?> configuration, ImplementationDetectionConfiguration config) {
        return this.fragmentMetadata.getFragmentInterfaces(configuration.getRepositoryInterface()).map(it -> this.detectRepositoryFragmentConfiguration((String)it, config, configuration)).flatMap(xva$0 -> Optionals.toStream(xva$0));
    }

    private Stream<RepositoryFragmentConfiguration> loadFragments(RepositoryConfiguration<?> configuration) {
        List<String> names = this.factoriesLoader.loadFactoryNames(configuration.getRepositoryInterface());
        if (names.isEmpty()) {
            return Stream.empty();
        }
        return names.stream().map(it -> this.createFragmentConfiguration(null, configuration, (String)it));
    }

    private Optional<RepositoryFragmentConfiguration> detectRepositoryFragmentConfiguration(String fragmentInterface, ImplementationDetectionConfiguration config, RepositoryConfiguration<?> configuration) {
        List<String> names = this.factoriesLoader.loadFactoryNames(fragmentInterface);
        if (names.isEmpty()) {
            ImplementationLookupConfiguration lookup = config.forFragment(fragmentInterface);
            Optional<AbstractBeanDefinition> beanDefinition = this.implementationDetector.detectCustomImplementation(lookup);
            return beanDefinition.map(bd -> RepositoryBeanDefinitionBuilder.createFragmentConfiguration(fragmentInterface, configuration, bd));
        }
        if (names.size() > 1) {
            logger.debug((Object)String.format("Multiple fragment implementations %s registered for fragment interface %s", names, fragmentInterface));
        }
        return Optional.of(this.createFragmentConfiguration(fragmentInterface, configuration, names.get(0)));
    }

    private RepositoryFragmentConfiguration createFragmentConfiguration(@Nullable String fragmentInterface, RepositoryConfiguration<?> configuration, String className) {
        try {
            MetadataReader metadataReader = this.metadataReaderFactory.getMetadataReader(className);
            AnnotatedGenericBeanDefinition bd = new AnnotatedGenericBeanDefinition(metadataReader.getAnnotationMetadata());
            return RepositoryBeanDefinitionBuilder.createFragmentConfiguration(fragmentInterface, configuration, (AbstractBeanDefinition)bd);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    private static RepositoryFragmentConfiguration createFragmentConfiguration(@Nullable String fragmentInterface, RepositoryConfiguration<?> configuration, AbstractBeanDefinition beanDefinition) {
        return new RepositoryFragmentConfiguration(fragmentInterface, beanDefinition, configuration.getConfigurationSource().generateBeanName((BeanDefinition)beanDefinition));
    }

    private String potentiallyRegisterRepositoryImplementation(RepositoryConfiguration<?> configuration, AbstractBeanDefinition beanDefinition) {
        String targetBeanName = configuration.getConfigurationSource().generateBeanName((BeanDefinition)beanDefinition);
        beanDefinition.setSource(configuration.getSource());
        if (this.registry.containsBeanDefinition(targetBeanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Custom repository implementation already registered: %s %s", targetBeanName, beanDefinition.getBeanClassName()));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Registering custom repository implementation: %s %s", targetBeanName, beanDefinition.getBeanClassName()));
            }
            this.registry.registerBeanDefinition(targetBeanName, (BeanDefinition)beanDefinition);
        }
        return targetBeanName;
    }

    private void potentiallyRegisterFragmentImplementation(RepositoryConfiguration<?> repositoryConfiguration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getImplementationBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Repository fragment implementation already registered: %s", beanName));
            }
            return;
        }
        fragmentConfiguration.getBeanDefinition().ifPresent(bd -> {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Registering repository fragment implementation: %s %s", beanName, fragmentConfiguration.getClassName()));
            }
            bd.setSource(repositoryConfiguration.getSource());
            this.registry.registerBeanDefinition(beanName, (BeanDefinition)bd);
        });
    }

    private void potentiallyRegisterRepositoryFragment(RepositoryConfiguration<?> configuration, RepositoryFragmentConfiguration fragmentConfiguration) {
        String beanName = fragmentConfiguration.getFragmentBeanName();
        if (this.registry.containsBeanDefinition(beanName)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("RepositoryFragment already registered: %s", beanName));
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("Registering RepositoryFragment: %s", beanName));
        }
        BeanDefinitionBuilder fragmentBuilder = BeanDefinitionBuilder.rootBeanDefinition(RepositoryFragment.class, (String)"implemented");
        if (StringUtils.hasText((String)fragmentConfiguration.getInterfaceName())) {
            fragmentBuilder.addConstructorArgValue((Object)fragmentConfiguration.getInterfaceName());
        }
        fragmentBuilder.addConstructorArgReference(fragmentConfiguration.getImplementationBeanName());
        this.registry.registerBeanDefinition(beanName, (BeanDefinition)ParsingUtils.getSourceBeanDefinition(fragmentBuilder, configuration.getSource()));
    }

    static class RepositoryFactoriesLoader
    extends SpringFactoriesLoader {
        private final Map<String, List<String>> factories;

        protected RepositoryFactoriesLoader(@Nullable ClassLoader classLoader, Map<String, List<String>> factories) {
            super(classLoader, factories);
            this.factories = factories;
        }

        public static RepositoryFactoriesLoader forDefaultResourceLocation(@Nullable ClassLoader classLoader) {
            ClassLoader resourceClassLoader = classLoader != null ? classLoader : SpringFactoriesLoader.class.getClassLoader();
            return new RepositoryFactoriesLoader(classLoader, RepositoryFactoriesLoader.loadFactoriesResource((ClassLoader)resourceClassLoader, (String)"META-INF/spring.factories"));
        }

        List<String> loadFactoryNames(String factoryType) {
            return this.factories.getOrDefault(factoryType, Collections.emptyList());
        }
    }
}

