/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.repository.core.support;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.repository.util.NullableWrapper;
import org.springframework.data.repository.util.QueryExecutionConverters;
import org.springframework.data.repository.util.ReactiveWrapperConverters;
import org.springframework.lang.Nullable;

class QueryExecutionResultHandler {
    private static final TypeDescriptor WRAPPER_TYPE = TypeDescriptor.valueOf(NullableWrapper.class);
    private final GenericConversionService conversionService;

    public QueryExecutionResultHandler() {
        DefaultConversionService conversionService = new DefaultConversionService();
        QueryExecutionConverters.registerConvertersIn((ConfigurableConversionService)conversionService);
        conversionService.removeConvertible(Object.class, Object.class);
        this.conversionService = conversionService;
    }

    @Nullable
    public Object postProcessInvocationResult(@Nullable Object result, Method method) {
        if (!QueryExecutionResultHandler.processingRequired(result, method.getReturnType())) {
            return result;
        }
        MethodParameter parameter = new MethodParameter(method, -1);
        return this.postProcessInvocationResult(result, 0, parameter);
    }

    @Nullable
    Object postProcessInvocationResult(@Nullable Object result, int nestingLevel, MethodParameter parameter) {
        TypeDescriptor returnTypeDescriptor = TypeDescriptor.nested((MethodParameter)parameter, (int)nestingLevel);
        if (returnTypeDescriptor == null) {
            return result;
        }
        Class expectedReturnType = returnTypeDescriptor.getType();
        result = QueryExecutionResultHandler.unwrapOptional(result);
        if (QueryExecutionConverters.supports(expectedReturnType)) {
            TypeDescriptor source;
            result = this.postProcessInvocationResult(result, nestingLevel + 1, parameter);
            if (this.conversionRequired(WRAPPER_TYPE, returnTypeDescriptor)) {
                return this.conversionService.convert((Object)new NullableWrapper(result), returnTypeDescriptor);
            }
            if (result != null && this.conversionRequired(source = TypeDescriptor.valueOf(result.getClass()), returnTypeDescriptor)) {
                return this.conversionService.convert(result, returnTypeDescriptor);
            }
        }
        if (result != null) {
            if (ReactiveWrapperConverters.supports(expectedReturnType)) {
                return ReactiveWrapperConverters.toWrapper(result, expectedReturnType);
            }
            return this.conversionService.canConvert(TypeDescriptor.forObject((Object)result), returnTypeDescriptor) ? this.conversionService.convert(result, returnTypeDescriptor) : result;
        }
        return Map.class.equals((Object)expectedReturnType) ? CollectionFactory.createMap((Class)expectedReturnType, (int)0) : null;
    }

    private boolean conversionRequired(TypeDescriptor source, TypeDescriptor target) {
        return this.conversionService.canConvert(source, target) && !this.conversionService.canBypassConvert(source, target);
    }

    @Nullable
    private static Object unwrapOptional(@Nullable Object source) {
        if (source == null) {
            return null;
        }
        return Optional.class.isInstance(source) ? ((Optional)Optional.class.cast(source)).orElse(null) : source;
    }

    private static boolean processingRequired(@Nullable Object source, Class<?> targetType) {
        return !targetType.isInstance(source) || source == null || Collection.class.isInstance(source);
    }
}

