/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.support;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;
import org.springframework.data.support.IsNewStrategy;
import org.springframework.data.support.IsNewStrategyFactory;

public class CachingIsNewStrategyFactory
implements IsNewStrategyFactory {
    @NonNull
    private final IsNewStrategyFactory delegate;
    private final Map<Class<?>, IsNewStrategy> cache = new ConcurrentHashMap();

    @Override
    public IsNewStrategy getIsNewStrategy(Class<?> type) {
        return this.cache.computeIfAbsent(type, this.delegate::getIsNewStrategy);
    }

    public CachingIsNewStrategyFactory(@NonNull IsNewStrategyFactory delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException("delegate is null");
        }
        this.delegate = delegate;
    }
}

