/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping.event;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.core.Ordered;
import org.springframework.data.auditing.ReactiveIsNewAwareAuditingHandler;
import org.springframework.data.cassandra.core.mapping.event.ReactiveBeforeConvertCallback;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class ReactiveAuditingEntityCallback
implements ReactiveBeforeConvertCallback<Object>,
Ordered {
    private final ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory;

    public ReactiveAuditingEntityCallback(ObjectFactory<ReactiveIsNewAwareAuditingHandler> auditingHandlerFactory) {
        Assert.notNull(auditingHandlerFactory, (String)"IsNewAwareAuditingHandler must not be null!");
        this.auditingHandlerFactory = auditingHandlerFactory;
    }

    @Override
    public Mono<Object> onBeforeConvert(Object entity, CqlIdentifier tableName) {
        return ((ReactiveIsNewAwareAuditingHandler)this.auditingHandlerFactory.getObject()).markAudited(entity);
    }

    public int getOrder() {
        return 100;
    }
}

