/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.convert;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.AnnotatedParameterizedType;
import java.lang.reflect.AnnotatedType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.data.cassandra.core.cql.keyspace.CreateIndexSpecification;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.Indexed;
import org.springframework.data.cassandra.core.mapping.SASI;
import org.springframework.data.mapping.MappingException;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

class IndexSpecificationFactory {
    private static final Map<Class<? extends Annotation>, CreateIndexConfigurer<? super Annotation>> INDEX_CONFIGURERS;

    IndexSpecificationFactory() {
    }

    static List<CreateIndexSpecification> createIndexSpecifications(CassandraPersistentProperty property) {
        AnnotatedType type;
        ArrayList<CreateIndexSpecification> indexes = new ArrayList<CreateIndexSpecification>();
        if (property.isAnnotationPresent(Indexed.class)) {
            CreateIndexSpecification index = IndexSpecificationFactory.createIndexSpecification((Indexed)property.findAnnotation(Indexed.class), property);
            if (property.isMapLike()) {
                index.entries();
            }
            indexes.add(index);
        }
        if (property.isAnnotationPresent(SASI.class)) {
            indexes.add(IndexSpecificationFactory.createIndexSpecification((SASI)property.findAnnotation(SASI.class), property));
        }
        if (property.isMapLike() && (type = property.findAnnotatedType(Indexed.class)) instanceof AnnotatedParameterizedType) {
            Indexed valueIndex;
            AnnotatedParameterizedType parameterizedType = (AnnotatedParameterizedType)type;
            AnnotatedType[] typeArgs = parameterizedType.getAnnotatedActualTypeArguments();
            Indexed keyIndex = typeArgs.length == 2 ? (Indexed)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)typeArgs[0], Indexed.class) : null;
            Indexed indexed = valueIndex = typeArgs.length == 2 ? (Indexed)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)typeArgs[1], Indexed.class) : null;
            if (!indexes.isEmpty() && (keyIndex != null || valueIndex != null) || keyIndex != null && valueIndex != null) {
                throw new MappingException("Multiple index declarations for " + property + " found. A map index must be either declared for entries, keys or values.");
            }
            if (keyIndex != null) {
                indexes.add(IndexSpecificationFactory.createIndexSpecification(keyIndex, property).keys());
            }
            if (valueIndex != null) {
                indexes.add(IndexSpecificationFactory.createIndexSpecification(valueIndex, property).values());
            }
        }
        return indexes;
    }

    static CreateIndexSpecification createIndexSpecification(Indexed annotation, CassandraPersistentProperty property) {
        CreateIndexSpecification index = StringUtils.hasText((String)annotation.value()) ? CreateIndexSpecification.createIndex(annotation.value()) : CreateIndexSpecification.createIndex();
        return index.columnName(property.getRequiredColumnName());
    }

    private static CreateIndexSpecification createIndexSpecification(SASI annotation, CassandraPersistentProperty property) {
        CreateIndexSpecification index = StringUtils.hasText((String)annotation.value()) ? CreateIndexSpecification.createIndex(annotation.value()) : CreateIndexSpecification.createIndex();
        index.using("org.apache.cassandra.index.sasi.SASIIndex").columnName(property.getRequiredColumnName()).withOption("mode", annotation.indexMode().name());
        long analyzerCount = INDEX_CONFIGURERS.keySet().stream().filter(arg_0 -> ((CassandraPersistentProperty)property).isAnnotationPresent(arg_0)).count();
        if (analyzerCount > 1L) {
            throw new IllegalStateException(String.format("SASI indexed property %s must be annotated only with a single analyzer annotation", property));
        }
        for (Class<? extends Annotation> annotationType : INDEX_CONFIGURERS.keySet()) {
            if (!property.isAnnotationPresent(annotationType)) continue;
            Annotation analyzed = property.findAnnotation(annotationType);
            INDEX_CONFIGURERS.get(annotationType).accept(analyzed, index);
        }
        return index;
    }

    static {
        HashMap<Class, Enum> configurers = new HashMap<Class, Enum>();
        configurers.put(SASI.StandardAnalyzed.class, StandardAnalyzedConfigurer.INSTANCE);
        configurers.put(SASI.NonTokenizingAnalyzed.class, NonTokenizingAnalyzedConfigurer.INSTANCE);
        INDEX_CONFIGURERS = Collections.unmodifiableMap(configurers);
    }

    static enum NonTokenizingAnalyzedConfigurer implements CreateIndexConfigurer<SASI.NonTokenizingAnalyzed>
    {
        INSTANCE;


        @Override
        public void accept(SASI.NonTokenizingAnalyzed nonTokenizingAnalyzed, CreateIndexSpecification index) {
            index.withOption("analyzed", "true");
            index.withOption("analyzer_class", "org.apache.cassandra.index.sasi.analyzer.NonTokenizingAnalyzer");
            index.withOption("case_sensitive", "" + nonTokenizingAnalyzed.caseSensitive());
            if (nonTokenizingAnalyzed.normalization() == SASI.Normalization.LOWERCASE) {
                index.withOption("normalize_lowercase", "true");
            }
            if (nonTokenizingAnalyzed.normalization() == SASI.Normalization.UPPERCASE) {
                index.withOption("normalize_uppercase", "true");
            }
        }
    }

    static enum StandardAnalyzedConfigurer implements CreateIndexConfigurer<SASI.StandardAnalyzed>
    {
        INSTANCE;


        @Override
        public void accept(SASI.StandardAnalyzed standardAnalyzed, CreateIndexSpecification index) {
            index.withOption("analyzed", "true");
            index.withOption("analyzer_class", "org.apache.cassandra.index.sasi.analyzer.StandardAnalyzer");
            index.withOption("tokenization_enable_stemming", "" + standardAnalyzed.enableStemming());
            if (standardAnalyzed.normalization() == SASI.Normalization.LOWERCASE) {
                index.withOption("tokenization_normalize_lowercase", "true");
            }
            if (standardAnalyzed.normalization() == SASI.Normalization.UPPERCASE) {
                index.withOption("tokenization_normalize_uppercase", "true");
            }
            if (StringUtils.hasText((String)standardAnalyzed.locale())) {
                index.withOption("tokenization_locale", standardAnalyzed.locale());
            }
            if (!ObjectUtils.isEmpty((Object)standardAnalyzed.skipStopWords())) {
                index.withOption("tokenization_skip_stop_words", "" + standardAnalyzed.skipStopWords());
            }
        }
    }

    static interface CreateIndexConfigurer<T extends Annotation>
    extends BiConsumer<T, CreateIndexSpecification> {
    }
}

