/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.repository.query;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.data.cassandra.repository.query.CassandraParameters;
import org.springframework.data.mapping.model.SpELExpressionEvaluator;
import org.springframework.data.repository.query.Parameter;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class BindingContext {
    private final CassandraParameters parameters;
    private final ParameterAccessor parameterAccessor;
    private final List<ParameterBinding> bindings;
    private final SpELExpressionEvaluator evaluator;

    public BindingContext(CassandraParameters parameters, ParameterAccessor parameterAccessor, List<ParameterBinding> bindings, SpELExpressionEvaluator evaluator) {
        this.parameters = parameters;
        this.parameterAccessor = parameterAccessor;
        this.bindings = bindings;
        this.evaluator = evaluator;
    }

    private boolean hasBindings() {
        return !this.bindings.isEmpty();
    }

    public List<Object> getBindingValues() {
        if (!this.hasBindings()) {
            return Collections.emptyList();
        }
        ArrayList<Object> parameters = new ArrayList<Object>(this.bindings.size());
        for (ParameterBinding binding : this.bindings) {
            Object parameterValueForBinding = this.getParameterValueForBinding(binding);
            parameters.add(parameterValueForBinding);
        }
        return parameters;
    }

    @Nullable
    private Object getParameterValueForBinding(ParameterBinding binding) {
        if (binding.isExpression()) {
            return this.evaluator.evaluate(binding.getRequiredExpression());
        }
        return binding.isNamed() ? this.parameterAccessor.getBindableValue(this.getParameterIndex(this.parameters, binding.getRequiredParameterName())) : this.parameterAccessor.getBindableValue(binding.getParameterIndex());
    }

    private int getParameterIndex(CassandraParameters parameters, String parameterName) {
        return parameters.stream().filter(cassandraParameter -> cassandraParameter.getName().filter(s -> s.equals(parameterName)).isPresent()).mapToInt(Parameter::getIndex).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid parameter name; Cannot resolve parameter [%s]", parameterName)));
    }

    static class ParameterBinding {
        private final int parameterIndex;
        @Nullable
        private final String expression;
        @Nullable
        private final String parameterName;

        private ParameterBinding(int parameterIndex, @Nullable String expression, @Nullable String parameterName) {
            this.parameterIndex = parameterIndex;
            this.expression = expression;
            this.parameterName = parameterName;
        }

        static ParameterBinding expression(String expression, boolean quoted) {
            return new ParameterBinding(-1, expression, null);
        }

        static ParameterBinding indexed(int parameterIndex) {
            return new ParameterBinding(parameterIndex, null, null);
        }

        static ParameterBinding named(String name) {
            return new ParameterBinding(-1, null, name);
        }

        boolean isNamed() {
            return this.parameterName != null;
        }

        int getParameterIndex() {
            return this.parameterIndex;
        }

        String getParameter() {
            return "?" + (this.isExpression() ? "expr" : "") + this.parameterIndex;
        }

        String getRequiredExpression() {
            Assert.state((this.expression != null ? 1 : 0) != 0, (String)"ParameterBinding is not an expression");
            return this.expression;
        }

        boolean isExpression() {
            return this.expression != null;
        }

        String getRequiredParameterName() {
            Assert.state((this.parameterName != null ? 1 : 0) != 0, (String)"ParameterBinding is not named");
            return this.parameterName;
        }
    }
}

