/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.core.mapping;

import org.springframework.data.cassandra.core.mapping.CassandraPersistentEntity;
import org.springframework.data.cassandra.core.mapping.CassandraPersistentProperty;
import org.springframework.data.cassandra.core.mapping.NamingStrategy;
import org.springframework.data.util.ParsingUtils;
import org.springframework.util.Assert;

public class SnakeCaseNamingStrategy
implements NamingStrategy {
    @Override
    public String getTableName(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return ParsingUtils.reconcatenateCamelCase((String)entity.getType().getSimpleName(), (String)"_");
    }

    @Override
    public String getUserDefinedTypeName(CassandraPersistentEntity<?> entity) {
        Assert.notNull(entity, (String)"CassandraPersistentEntity must not be null");
        return ParsingUtils.reconcatenateCamelCase((String)entity.getType().getSimpleName(), (String)"_");
    }

    @Override
    public String getColumnName(CassandraPersistentProperty property) {
        Assert.notNull((Object)property, (String)"CassandraPersistentProperty must not be null");
        return ParsingUtils.reconcatenateCamelCase((String)property.getName(), (String)"_");
    }
}

