/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.cassandra.config;

import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

abstract class ParsingUtils {
    ParsingUtils() {
    }

    public static void addOptionalPropertyReference(BeanDefinitionBuilder builder, String propertyName, Attr attribute, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, attribute.getValue(), defaultValue, false, true);
    }

    public static void addOptionalPropertyReference(BeanDefinitionBuilder builder, String propertyName, Element element, String attributeName) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attributeName), null, false, true);
    }

    public static void addOptionalPropertyReference(BeanDefinitionBuilder builder, String propertyName, Element element, String attributeName, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attributeName), defaultValue, false, true);
    }

    public static void addOptionalPropertyValue(BeanDefinitionBuilder builder, String propertyName, Attr attribute, String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, attribute.getValue(), defaultValue, false, false);
    }

    public static void addOptionalPropertyValue(BeanDefinitionBuilder builder, String propertyName, Element element, String attributeName) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attributeName), null, false, false);
    }

    public static void addOptionalPropertyValue(BeanDefinitionBuilder builder, String propertyName, Element element, String attributeName, @Nullable String defaultValue) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attributeName), defaultValue, false, false);
    }

    public static void addRequiredPropertyReference(BeanDefinitionBuilder builder, String propertyName, Element element, String attributeName) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attributeName), null, true, true);
    }

    public static void addRequiredPropertyReference(BeanDefinitionBuilder builder, String propertyName, String value) {
        ParsingUtils.addProperty(builder, propertyName, value, null, true, true);
    }

    public static void addRequiredPropertyValue(BeanDefinitionBuilder builder, String propertyName, Attr attribute) {
        ParsingUtils.addProperty(builder, propertyName, attribute.getValue(), null, true, false);
    }

    public static void addRequiredPropertyValue(BeanDefinitionBuilder builder, String propertyName, Element element, String attributeName) {
        ParsingUtils.addProperty(builder, propertyName, element.getAttribute(attributeName), null, true, false);
    }

    public static void addRequiredPropertyValue(BeanDefinitionBuilder builder, String propertyName, String value) {
        ParsingUtils.addProperty(builder, propertyName, value, null, true, false);
    }

    public static BeanDefinitionBuilder addProperty(BeanDefinitionBuilder builder, String propertyName, String value, @Nullable String defaultValue, boolean required, boolean reference) {
        Assert.notNull((Object)builder, (String)"BeanDefinitionBuilder must not be null");
        Assert.hasText((String)propertyName, (String)"Property name must not be null");
        if (!StringUtils.hasText((String)value)) {
            if (required) {
                throw new IllegalArgumentException(String.format("value required for property %1$s[%2$s] on class [%3$s]", reference ? "reference " : "", propertyName, builder.getRawBeanDefinition().getBeanClassName()));
            }
            value = defaultValue;
        }
        if (StringUtils.hasText((String)value)) {
            if (reference) {
                builder.addPropertyReference(propertyName, value);
            } else {
                builder.addPropertyValue(propertyName, (Object)value);
            }
        }
        return builder;
    }

    public static AbstractBeanDefinition getSourceBeanDefinition(BeanDefinitionBuilder builder, ParserContext parserContext, Element element) {
        Assert.notNull((Object)parserContext, (String)"ParserContext must not be null");
        return ParsingUtils.getSourceBeanDefinition(builder, parserContext.extractSource((Object)element));
    }

    public static AbstractBeanDefinition getSourceBeanDefinition(BeanDefinitionBuilder builder, Object source) {
        Assert.notNull((Object)builder, (String)"BeanDefinitionBuilder must not be null");
        AbstractBeanDefinition beanDefinition = builder.getBeanDefinition();
        beanDefinition.setSource(source);
        return beanDefinition;
    }
}

