/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.metric;

import org.springframework.boot.actuate.metrics.CounterService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.metric.CounterServiceBasedSpanMetricReporter;
import org.springframework.cloud.sleuth.metric.NoOpSpanMetricReporter;
import org.springframework.cloud.sleuth.metric.SleuthMetricProperties;
import org.springframework.cloud.sleuth.metric.SpanMetricReporter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.sleuth.metrics.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties
public class TraceMetricsAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    public SleuthMetricProperties sleuthMetricProperties() {
        return new SleuthMetricProperties();
    }

    @Bean
    @ConditionalOnMissingClass(value={"org.springframework.boot.actuate.metrics.CounterService"})
    @ConditionalOnMissingBean(value={SpanMetricReporter.class})
    public SpanMetricReporter noOpSpanReporterCounterService() {
        return new NoOpSpanMetricReporter();
    }

    @Configuration
    @ConditionalOnClass(value={CounterService.class})
    @ConditionalOnMissingBean(value={SpanMetricReporter.class})
    protected static class CounterServiceSpanReporterConfig {
        protected CounterServiceSpanReporterConfig() {
        }

        @Bean
        @ConditionalOnBean(value={CounterService.class})
        public SpanMetricReporter spanReporterCounterService(CounterService counterService, SleuthMetricProperties sleuthMetricProperties) {
            return new CounterServiceBasedSpanMetricReporter(sleuthMetricProperties.getSpan().getAcceptedName(), sleuthMetricProperties.getSpan().getDroppedName(), counterService);
        }

        @Bean
        @ConditionalOnMissingBean(value={CounterService.class})
        public SpanMetricReporter noOpSpanReporterCounterService() {
            return new NoOpSpanMetricReporter();
        }
    }
}

