/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.RetryableException;
import feign.Retryer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignRequestContext;

final class TraceFeignRetryer
implements Retryer {
    private final Tracer tracer;
    private final FeignRequestContext feignRequestContext = FeignRequestContext.getInstance();
    private final Retryer delegate;

    TraceFeignRetryer(Tracer tracer) {
        this(tracer, (Retryer)new Retryer.Default());
    }

    TraceFeignRetryer(Tracer tracer, Retryer delegate) {
        this.tracer = tracer;
        this.delegate = delegate;
    }

    public void continueOrPropagate(RetryableException e) {
        try {
            this.feignRequestContext.putSpan(this.tracer.getCurrentSpan(), true);
            this.tracer.getCurrentSpan().logEvent("feign.retry");
            this.delegate.continueOrPropagate(e);
        }
        catch (RetryableException e2) {
            this.tracer.close(this.tracer.getCurrentSpan());
            throw e2;
        }
    }

    public Retryer clone() {
        return new TraceFeignRetryer(this.tracer);
    }
}

