/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Request;
import feign.Response;
import feign.RetryableException;
import java.io.IOException;
import java.util.Objects;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.client.feign.FeignEventPublisher;

final class TraceFeignClient
extends FeignEventPublisher
implements Client {
    private final Client delegate;

    TraceFeignClient(Tracer tracer) {
        super(tracer);
        this.delegate = new Client.Default(null, null);
    }

    TraceFeignClient(Tracer tracer, Client delegate) {
        super(tracer);
        this.delegate = delegate;
    }

    public Response execute(Request request, Request.Options options) throws IOException {
        Response response = null;
        try {
            response = this.delegate.execute(request, options);
        }
        catch (RetryableException | IOException e) {
            throw e;
        }
        catch (RuntimeException e) {
            this.finish();
            throw e;
        }
        if (response != null && response.body() == null || response.body() != null && Objects.equals(response.body().length(), 0)) {
            this.finish();
        }
        return response;
    }
}

