/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.RequestTemplate;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.util.StringUtils;

class FeignRequestTemplateInjector
implements SpanInjector<RequestTemplate> {
    FeignRequestTemplateInjector() {
    }

    @Override
    public void inject(Span span, RequestTemplate carrier) {
        if (span == null) {
            this.setHeader(carrier, "X-B3-Sampled", "0");
            return;
        }
        carrier.header("X-B3-TraceId", new String[]{Span.idToHex(span.getTraceId())});
        this.setHeader(carrier, "X-Span-Name", span.getName());
        this.setHeader(carrier, "X-B3-SpanId", Span.idToHex(span.getSpanId()));
        this.setHeader(carrier, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        Long parentId = this.getParentId(span);
        if (parentId != null) {
            this.setHeader(carrier, "X-B3-ParentSpanId", Span.idToHex(parentId));
        }
        this.setHeader(carrier, "X-Process-Id", span.getProcessId());
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    protected void setHeader(RequestTemplate request, String name, String value) {
        if (StringUtils.hasText((String)value) && !request.headers().containsKey(name)) {
            request.header(name, new String[]{value});
        }
    }
}

