/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.ErrorDecoder;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignDecoder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignErrorDecoder;
import org.springframework.cloud.sleuth.instrument.web.client.feign.TraceFeignRetryer;

final class FeignBeanPostProcessor
implements BeanPostProcessor {
    private Tracer tracer;
    private final BeanFactory beanFactory;

    FeignBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Decoder && !(bean instanceof TraceFeignDecoder)) {
            return new TraceFeignDecoder(this.getTracer(), (Decoder)bean);
        }
        if (bean instanceof Retryer && !(bean instanceof TraceFeignRetryer)) {
            return new TraceFeignRetryer(this.getTracer(), (Retryer)bean);
        }
        if (bean instanceof Client && !(bean instanceof TraceFeignClient)) {
            return new TraceFeignClient(this.getTracer(), (Client)bean);
        }
        if (bean instanceof ErrorDecoder && !(bean instanceof TraceFeignErrorDecoder)) {
            return new TraceFeignErrorDecoder(this.getTracer(), (ErrorDecoder)bean);
        }
        return bean;
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

