/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.http.HttpRequest;
import org.springframework.util.StringUtils;

class HttpRequestInjector
implements SpanInjector<HttpRequest> {
    HttpRequestInjector() {
    }

    @Override
    public void inject(Span span, HttpRequest carrier) {
        this.setIdHeader(carrier, "X-B3-TraceId", span.getTraceId());
        this.setIdHeader(carrier, "X-B3-SpanId", span.getSpanId());
        this.setHeader(carrier, "X-B3-Sampled", span.isExportable() ? "1" : "0");
        this.setHeader(carrier, "X-Span-Name", span.getName());
        this.setIdHeader(carrier, "X-B3-ParentSpanId", this.getParentId(span));
        this.setHeader(carrier, "X-Process-Id", span.getProcessId());
    }

    private Long getParentId(Span span) {
        return !span.getParents().isEmpty() ? span.getParents().get(0) : null;
    }

    private void setHeader(HttpRequest request, String name, String value) {
        if (StringUtils.hasText((String)value) && !request.getHeaders().containsKey((Object)name)) {
            request.getHeaders().add(name, value);
        }
    }

    private void setIdHeader(HttpRequest request, String name, Long value) {
        if (value != null) {
            this.setHeader(request, name, Span.idToHex(value));
        }
    }
}

