/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client;

import java.net.URI;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.http.HttpRequest;

abstract class AbstractTraceHttpRequestInterceptor {
    protected final Tracer tracer;
    protected final SpanInjector<HttpRequest> spanInjector;

    protected AbstractTraceHttpRequestInterceptor(Tracer tracer, SpanInjector<HttpRequest> spanInjector) {
        this.tracer = tracer;
        this.spanInjector = spanInjector;
    }

    protected void publishStartEvent(HttpRequest request) {
        URI uri = request.getURI();
        String spanName = this.uriScheme(uri) + ":" + uri.getPath();
        Span newSpan = this.tracer.createSpan(spanName);
        this.spanInjector.inject(newSpan, request);
        newSpan.logEvent("cs");
    }

    private String uriScheme(URI uri) {
        return uri.getScheme() == null ? "http" : uri.getScheme();
    }

    public void finish() {
        if (!this.isTracing()) {
            return;
        }
        this.currentSpan().logEvent("cr");
        this.tracer.close(this.currentSpan());
    }

    protected Span currentSpan() {
        return this.tracer.getCurrentSpan();
    }

    protected boolean isTracing() {
        return this.tracer.isTracing();
    }
}

