/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.cloud.sleuth.SpanNamer;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.instrument.async.TraceContinuingCallable;
import org.springframework.web.context.request.async.WebAsyncTask;

@Aspect
public class TraceWebAspect {
    private static final Log log = LogFactory.getLog(TraceWebAspect.class);
    private final Tracer tracer;
    private final SpanNamer spanNamer;

    public TraceWebAspect(Tracer tracer, SpanNamer spanNamer) {
        this.tracer = tracer;
        this.spanNamer = spanNamer;
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController)")
    private void anyRestControllerAnnotated() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Controller)")
    private void anyControllerAnnotated() {
    }

    @Pointcut(value="execution(public java.util.concurrent.Callable *(..))")
    private void anyPublicMethodReturningCallable() {
    }

    @Pointcut(value="(anyRestControllerAnnotated() || anyControllerAnnotated()) && anyPublicMethodReturningCallable()")
    private void anyControllerOrRestControllerWithPublicAsyncMethod() {
    }

    @Pointcut(value="execution(public org.springframework.web.context.request.async.WebAsyncTask *(..))")
    private void anyPublicMethodReturningWebAsyncTask() {
    }

    @Pointcut(value="(anyRestControllerAnnotated() || anyControllerAnnotated()) && anyPublicMethodReturningWebAsyncTask()")
    private void anyControllerOrRestControllerWithPublicWebAsyncTaskMethod() {
    }

    @Around(value="anyControllerOrRestControllerWithPublicAsyncMethod()")
    public Object wrapWithCorrelationId(ProceedingJoinPoint pjp) throws Throwable {
        Callable callable = (Callable)pjp.proceed();
        if (this.tracer.isTracing()) {
            log.debug((Object)("Wrapping callable with span [" + this.tracer.getCurrentSpan() + "]"));
            return new TraceContinuingCallable(this.tracer, this.spanNamer, callable);
        }
        return callable;
    }

    @Around(value="anyControllerOrRestControllerWithPublicWebAsyncTaskMethod()")
    public Object wrapWebAsyncTaskWithCorrelationId(ProceedingJoinPoint pjp) throws Throwable {
        WebAsyncTask webAsyncTask = (WebAsyncTask)pjp.proceed();
        if (this.tracer.isTracing()) {
            try {
                log.debug((Object)("Wrapping callable with span [" + this.tracer.getCurrentSpan() + "]"));
                Field callableField = WebAsyncTask.class.getDeclaredField("callable");
                callableField.setAccessible(true);
                callableField.set(webAsyncTask, new TraceContinuingCallable(this.tracer, this.spanNamer, webAsyncTask.getCallable()));
            }
            catch (NoSuchFieldException ex) {
                log.warn((Object)"Cannot wrap webAsyncTask's callable with TraceCallable", (Throwable)ex);
            }
        }
        return webAsyncTask;
    }
}

