/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web;

import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanInjector;

class HttpServletResponseInjector
implements SpanInjector<HttpServletResponse> {
    HttpServletResponseInjector() {
    }

    @Override
    public void inject(Span span, HttpServletResponse carrier) {
        if (span == null) {
            return;
        }
        if (!carrier.containsHeader("X-B3-SpanId")) {
            carrier.addHeader("X-B3-SpanId", Span.idToHex(span.getSpanId()));
            carrier.addHeader("X-B3-TraceId", Span.idToHex(span.getTraceId()));
        }
    }
}

