/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.messaging;

import java.util.Random;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanExtractor;
import org.springframework.messaging.Message;

public class MessagingSpanExtractor
implements SpanExtractor<Message<?>> {
    private final Random random;

    public MessagingSpanExtractor(Random random) {
        this.random = random;
    }

    @Override
    public Span joinTrace(Message<?> carrier) {
        if (!this.hasHeader(carrier, "X-B3-TraceId") || !this.hasHeader(carrier, "X-B3-SpanId")) {
            return null;
        }
        long spanId = this.hasHeader(carrier, "X-B3-SpanId") ? Span.hexToId(this.getHeader(carrier, "X-B3-SpanId")) : this.random.nextLong();
        long traceId = Span.hexToId(this.getHeader(carrier, "X-B3-TraceId"));
        Span.SpanBuilder spanBuilder = Span.builder().traceId(traceId).spanId(spanId);
        spanBuilder.exportable("1".equals(this.getHeader(carrier, "X-B3-Sampled")));
        String parentId = this.getHeader(carrier, "X-B3-ParentSpanId");
        String processId = this.getHeader(carrier, "X-Process-Id");
        String spanName = this.getHeader(carrier, "X-Span-Name");
        if (spanName != null) {
            spanBuilder.name(spanName);
        }
        if (processId != null) {
            spanBuilder.processId(processId);
        }
        if (parentId != null) {
            spanBuilder.parent(Span.hexToId(parentId));
        }
        spanBuilder.remote(true);
        return spanBuilder.build();
    }

    String getHeader(Message<?> message, String name) {
        return this.getHeader(message, name, String.class);
    }

    <T> T getHeader(Message<?> message, String name, Class<T> type) {
        return (T)message.getHeaders().get((Object)name, type);
    }

    boolean hasHeader(Message<?> message, String name) {
        return message.getHeaders().containsKey((Object)name);
    }
}

