/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.sleuth.Log;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class Span {
    public static final String SAMPLED_NAME = "X-B3-Sampled";
    public static final String PROCESS_ID_NAME = "X-Process-Id";
    public static final String PARENT_ID_NAME = "X-B3-ParentSpanId";
    public static final String TRACE_ID_NAME = "X-B3-TraceId";
    public static final String SPAN_NAME_NAME = "X-Span-Name";
    public static final String SPAN_ID_NAME = "X-B3-SpanId";
    public static final String SPAN_EXPORT_NAME = "X-Span-Export";
    public static final Set<String> SPAN_HEADERS = new HashSet<String>(Arrays.asList("X-B3-Sampled", "X-Process-Id", "X-B3-ParentSpanId", "X-B3-TraceId", "X-B3-SpanId", "X-Span-Name", "X-Span-Export"));
    public static final String SPAN_SAMPLED = "1";
    public static final String SPAN_NOT_SAMPLED = "0";
    public static final String SPAN_LOCAL_COMPONENT_TAG_NAME = "lc";
    public static final String CLIENT_RECV = "cr";
    public static final String CLIENT_SEND = "cs";
    public static final String SERVER_RECV = "sr";
    public static final String SERVER_SEND = "ss";
    public static final String SPAN_PEER_SERVICE_TAG_NAME = "peer.service";
    private final long begin;
    private long end = 0L;
    private final String name;
    private final long traceId;
    private List<Long> parents = new ArrayList<Long>();
    private final long spanId;
    private boolean remote = false;
    private boolean exportable = true;
    private final Map<String, String> tags;
    private final String processId;
    private final List<Log> logs;
    private final Span savedSpan;

    private Span() {
        this(-1L, -1L, "dummy", 0L, Collections.emptyList(), 0L, false, false, null);
    }

    public Span(Span current, Span savedSpan) {
        this.begin = current.getBegin();
        this.end = current.getEnd();
        this.name = current.getName();
        this.traceId = current.getTraceId();
        this.parents = current.getParents();
        this.spanId = current.getSpanId();
        this.remote = current.isRemote();
        this.exportable = current.isExportable();
        this.processId = current.getProcessId();
        this.tags = current.tags;
        this.logs = current.logs;
        this.savedSpan = savedSpan;
    }

    public Span(long begin, long end, String name, long traceId, List<Long> parents, long spanId, boolean remote, boolean exportable, String processId) {
        this(begin, end, name, traceId, parents, spanId, remote, exportable, processId, null);
    }

    public Span(long begin, long end, String name, long traceId, List<Long> parents, long spanId, boolean remote, boolean exportable, String processId, Span savedSpan) {
        this.begin = begin <= 0L ? System.currentTimeMillis() : begin;
        this.end = end;
        this.name = name != null ? name : "";
        this.traceId = traceId;
        this.parents = parents;
        this.spanId = spanId;
        this.remote = remote;
        this.exportable = exportable;
        this.processId = processId;
        this.savedSpan = savedSpan;
        this.tags = new LinkedHashMap<String, String>();
        this.logs = new ArrayList<Log>();
    }

    public static SpanBuilder builder() {
        return new SpanBuilder();
    }

    public synchronized void stop() {
        if (this.end == 0L) {
            if (this.begin == 0L) {
                throw new IllegalStateException("Span for " + this.name + " has not been started");
            }
            this.end = System.currentTimeMillis();
        }
    }

    @JsonIgnore
    public synchronized long getAccumulatedMillis() {
        if (this.begin == 0L) {
            return 0L;
        }
        if (this.end > 0L) {
            return this.end - this.begin;
        }
        return System.currentTimeMillis() - this.begin;
    }

    @JsonIgnore
    public synchronized boolean isRunning() {
        return this.begin != 0L && this.end == 0L;
    }

    public void tag(String key, String value) {
        if (StringUtils.hasText((String)value)) {
            this.tags.put(key, value);
        }
    }

    public void logEvent(String event) {
        this.logs.add(new Log(System.currentTimeMillis(), event));
    }

    public Map<String, String> tags() {
        return Collections.unmodifiableMap(this.tags);
    }

    public List<Log> logs() {
        return Collections.unmodifiableList(this.logs);
    }

    @JsonIgnore
    public Span getSavedSpan() {
        return this.savedSpan;
    }

    public boolean hasSavedSpan() {
        return this.savedSpan != null;
    }

    public String getName() {
        return this.name;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public List<Long> getParents() {
        return this.parents;
    }

    public boolean isRemote() {
        return this.remote;
    }

    public long getBegin() {
        return this.begin;
    }

    public long getEnd() {
        return this.end;
    }

    public boolean isExportable() {
        return this.exportable;
    }

    public static String idToHex(long id) {
        return Long.toHexString(id);
    }

    public static long hexToId(String hexString) {
        Assert.hasText((String)hexString, (String)"Can't convert empty hex string to long");
        return new BigInteger(hexString, 16).longValue();
    }

    public String toString() {
        return "[Trace: " + Span.idToHex(this.traceId) + ", Span: " + Span.idToHex(this.spanId) + ", exportable=" + this.exportable + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.spanId ^ this.spanId >>> 32);
        result = 31 * result + (int)(this.traceId ^ this.traceId >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Span other = (Span)obj;
        if (this.spanId != other.spanId) {
            return false;
        }
        return this.traceId == other.traceId;
    }

    public static class SpanBuilder {
        private long begin;
        private long end;
        private String name;
        private long traceId;
        private ArrayList<Long> parents = new ArrayList();
        private long spanId;
        private boolean remote;
        private boolean exportable = true;
        private String processId;
        private Span savedSpan;
        private List<Log> logs = new ArrayList<Log>();
        private Map<String, String> tags = new LinkedHashMap<String, String>();

        SpanBuilder() {
        }

        public SpanBuilder begin(long begin) {
            this.begin = begin;
            return this;
        }

        public SpanBuilder end(long end) {
            this.end = end;
            return this;
        }

        public SpanBuilder name(String name) {
            this.name = name;
            return this;
        }

        public SpanBuilder traceId(long traceId) {
            this.traceId = traceId;
            return this;
        }

        public SpanBuilder parent(Long parent) {
            this.parents.add(parent);
            return this;
        }

        public SpanBuilder parents(Collection<Long> parents) {
            this.parents.addAll(parents);
            return this;
        }

        public SpanBuilder log(Log log) {
            this.logs.add(log);
            return this;
        }

        public SpanBuilder logs(Collection<Log> logs) {
            this.logs.addAll(logs);
            return this;
        }

        public SpanBuilder tag(String tagKey, String tagValue) {
            this.tags.put(tagKey, tagValue);
            return this;
        }

        public SpanBuilder tags(Map<String, String> tags) {
            this.tags.putAll(tags);
            return this;
        }

        public SpanBuilder spanId(long spanId) {
            this.spanId = spanId;
            return this;
        }

        public SpanBuilder remote(boolean remote) {
            this.remote = remote;
            return this;
        }

        public SpanBuilder exportable(boolean exportable) {
            this.exportable = exportable;
            return this;
        }

        public SpanBuilder processId(String processId) {
            this.processId = processId;
            return this;
        }

        public SpanBuilder savedSpan(Span savedSpan) {
            this.savedSpan = savedSpan;
            return this;
        }

        public Span build() {
            Span span = new Span(this.begin, this.end, this.name, this.traceId, this.parents, this.spanId, this.remote, this.exportable, this.processId, this.savedSpan);
            span.logs.addAll(this.logs);
            span.tags.putAll(this.tags);
            return span;
        }

        public String toString() {
            return "SpanBuilder{begin=" + this.begin + ", end=" + this.end + ", name=" + this.name + ", traceId=" + this.traceId + ", parents=" + this.parents + ", spanId=" + this.spanId + ", remote=" + this.remote + ", exportable=" + this.exportable + ", processId='" + this.processId + '\'' + ", savedSpan=" + this.savedSpan + ", logs=" + this.logs + ", tags=" + this.tags + '}';
        }
    }
}

