/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.autoconfigure.vectorstore.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.config.DefaultDriverOption;
import com.datastax.oss.driver.api.core.config.DriverOption;
import com.datastax.oss.driver.api.core.config.ProgrammaticDriverConfigLoaderBuilder;
import io.micrometer.observation.ObservationRegistry;
import java.time.Duration;
import org.springframework.ai.autoconfigure.vectorstore.cassandra.CassandraVectorStoreProperties;
import org.springframework.ai.embedding.BatchingStrategy;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.ai.embedding.TokenCountBatchingStrategy;
import org.springframework.ai.vectorstore.cassandra.CassandraVectorStore;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationConvention;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration;
import org.springframework.boot.autoconfigure.cassandra.DriverConfigLoaderBuilderCustomizer;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(after={CassandraAutoConfiguration.class})
@ConditionalOnClass(value={CassandraVectorStore.class, CqlSession.class})
@EnableConfigurationProperties(value={CassandraVectorStoreProperties.class})
public class CassandraVectorStoreAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={BatchingStrategy.class})
    BatchingStrategy batchingStrategy() {
        return new TokenCountBatchingStrategy();
    }

    @Bean
    @ConditionalOnMissingBean
    public CassandraVectorStore vectorStore(EmbeddingModel embeddingModel, CassandraVectorStoreProperties properties, CqlSession cqlSession, ObjectProvider<ObservationRegistry> observationRegistry, ObjectProvider<VectorStoreObservationConvention> customObservationConvention, BatchingStrategy batchingStrategy) {
        return ((CassandraVectorStore.Builder)((CassandraVectorStore.Builder)((CassandraVectorStore.Builder)CassandraVectorStore.builder((EmbeddingModel)embeddingModel).session(cqlSession).keyspace(properties.getKeyspace()).table(properties.getTable()).contentColumnName(properties.getContentColumnName()).embeddingColumnName(properties.getEmbeddingColumnName()).indexName(properties.getIndexName()).fixedThreadPoolExecutorSize(properties.getFixedThreadPoolExecutorSize()).disallowSchemaChanges(!properties.isInitializeSchema()).returnEmbeddings(properties.getReturnEmbeddings()).observationRegistry((ObservationRegistry)observationRegistry.getIfUnique(() -> ObservationRegistry.NOOP))).customObservationConvention((VectorStoreObservationConvention)customObservationConvention.getIfAvailable(() -> null))).batchingStrategy(batchingStrategy)).build();
    }

    @Bean
    public DriverConfigLoaderBuilderCustomizer driverConfigLoaderBuilderCustomizer() {
        return builder -> ((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)((ProgrammaticDriverConfigLoaderBuilder)builder.startProfile("spring-ai-updates").withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, "LOCAL_QUORUM")).withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(1L))).withBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, true)).endProfile().startProfile("spring-ai-search").withString((DriverOption)DefaultDriverOption.REQUEST_CONSISTENCY, "LOCAL_ONE")).withDuration((DriverOption)DefaultDriverOption.REQUEST_TIMEOUT, Duration.ofSeconds(10L))).withBoolean((DriverOption)DefaultDriverOption.REQUEST_DEFAULT_IDEMPOTENCE, true)).endProfile();
    }
}

