/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.observation;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationHandler;
import io.micrometer.tracing.handler.TracingObservationHandler;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import java.util.List;
import org.springframework.ai.observation.conventions.VectorStoreObservationAttributes;
import org.springframework.ai.observation.conventions.VectorStoreObservationEventNames;
import org.springframework.ai.observation.tracing.TracingHelper;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContentProcessor;
import org.springframework.ai.vectorstore.observation.VectorStoreObservationContext;
import org.springframework.util.CollectionUtils;

public class VectorStoreQueryResponseObservationHandler
implements ObservationHandler<VectorStoreObservationContext> {
    public void onStop(VectorStoreObservationContext context) {
        TracingObservationHandler.TracingContext tracingContext = (TracingObservationHandler.TracingContext)context.get(TracingObservationHandler.TracingContext.class);
        Span otelSpan = TracingHelper.extractOtelSpan(tracingContext);
        List<String> documents = VectorStoreObservationContentProcessor.documents(context);
        if (!CollectionUtils.isEmpty(documents) && otelSpan != null) {
            otelSpan.addEvent(VectorStoreObservationEventNames.CONTENT_QUERY_RESPONSE.value(), Attributes.of((AttributeKey)AttributeKey.stringArrayKey((String)VectorStoreObservationAttributes.DB_VECTOR_QUERY_CONTENT.value()), documents));
        }
    }

    public boolean supportsContext(Observation.Context context) {
        return context instanceof VectorStoreObservationContext;
    }
}

