/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.filter.converter;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class SimpleVectorStoreFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    private static final Pattern DATE_FORMAT_PATTERN = Pattern.compile("\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}:\\d{2}Z");
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

    public SimpleVectorStoreFilterExpressionConverter() {
        this.dateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    @Override
    protected void doExpression(Filter.Expression expression, StringBuilder context) {
        this.convertOperand(expression.left(), context);
        context.append(this.getOperationSymbol(expression));
        this.convertOperand(expression.right(), context);
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return switch (exp.type()) {
            case Filter.ExpressionType.AND -> " and ";
            case Filter.ExpressionType.OR -> " or ";
            case Filter.ExpressionType.EQ -> " == ";
            case Filter.ExpressionType.LT -> " < ";
            case Filter.ExpressionType.LTE -> " <= ";
            case Filter.ExpressionType.GT -> " > ";
            case Filter.ExpressionType.GTE -> " >= ";
            case Filter.ExpressionType.NE -> " != ";
            case Filter.ExpressionType.IN -> " in ";
            case Filter.ExpressionType.NIN -> " not in ";
            default -> throw new RuntimeException("Not supported expression type: " + String.valueOf((Object)exp.type()));
        };
    }

    @Override
    protected void doKey(Filter.Key key, StringBuilder context) {
        String identifier = this.hasOuterQuotes(key.key()) ? this.removeOuterQuotes(key.key()) : key.key();
        context.append("#metadata['").append(identifier).append("']");
    }

    @Override
    protected void doValue(Filter.Value filterValue, StringBuilder context) {
        Object object = filterValue.value();
        if (object instanceof List) {
            List list = (List)object;
            StringBuilder formattedList = new StringBuilder("{");
            int c = 0;
            for (Object v : list) {
                this.doSingleValue(v, formattedList);
                if (c++ >= list.size() - 1) continue;
                this.doAddValueRangeSpitter(filterValue, formattedList);
            }
            formattedList.append("}");
            if (context.lastIndexOf("in ") == -1) {
                context.append((CharSequence)formattedList);
            } else {
                this.appendSpELContains(formattedList, context);
            }
        } else {
            this.doSingleValue(filterValue.value(), context);
        }
    }

    private void appendSpELContains(StringBuilder formattedList, StringBuilder context) {
        int metadataStart = context.lastIndexOf("#metadata");
        if (metadataStart == -1) {
            throw new RuntimeException("Wrong SpEL expression: " + String.valueOf(context));
        }
        int metadataEnd = context.indexOf(" ", metadataStart);
        String metadata = context.substring(metadataStart, metadataEnd);
        context.setLength(context.lastIndexOf("in "));
        context.delete(metadataStart, metadataEnd + 1);
        context.append((CharSequence)formattedList).append(".contains(").append(metadata).append(")");
    }

    @Override
    protected void doSingleValue(Object value, StringBuilder context) {
        if (value instanceof Date) {
            Date date = (Date)value;
            context.append("'");
            context.append(this.dateFormat.format(date));
            context.append("'");
        } else if (value instanceof String) {
            String text = (String)value;
            context.append("'");
            if (DATE_FORMAT_PATTERN.matcher(text).matches()) {
                try {
                    Date date = this.dateFormat.parse(text);
                    context.append(this.dateFormat.format(date));
                }
                catch (ParseException e) {
                    throw new IllegalArgumentException("Invalid date type:" + text, e);
                }
            } else {
                context.append(text);
            }
            context.append("'");
        } else {
            context.append(value);
        }
    }

    @Override
    protected void doGroup(Filter.Group group, StringBuilder context) {
        context.append("(");
        super.doGroup(group, context);
        context.append(")");
    }
}

