/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.vectorstore.filter.converter;

import org.springframework.ai.vectorstore.filter.Filter;
import org.springframework.ai.vectorstore.filter.converter.AbstractFilterExpressionConverter;

public class PineconeFilterExpressionConverter
extends AbstractFilterExpressionConverter {
    @Override
    protected void doExpression(Filter.Expression exp, StringBuilder context) {
        context.append("{");
        if (exp.type() == Filter.ExpressionType.AND || exp.type() == Filter.ExpressionType.OR) {
            context.append(this.getOperationSymbol(exp));
            context.append("[");
            this.convertOperand(exp.left(), context);
            context.append(",");
            this.convertOperand(exp.right(), context);
            context.append("]");
        } else {
            this.convertOperand(exp.left(), context);
            context.append("{");
            context.append(this.getOperationSymbol(exp));
            this.convertOperand(exp.right(), context);
            context.append("}");
        }
        context.append("}");
    }

    private String getOperationSymbol(Filter.Expression exp) {
        return "\"$" + exp.type().toString().toLowerCase() + "\": ";
    }

    @Override
    protected void doKey(Filter.Key key, StringBuilder context) {
        String identifier = this.hasOuterQuotes(key.key()) ? this.removeOuterQuotes(key.key()) : key.key();
        context.append("\"" + identifier + "\": ");
    }
}

