/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.moderation;

import java.util.Objects;

public final class Categories {
    private final boolean sexual;
    private final boolean hate;
    private final boolean harassment;
    private final boolean selfHarm;
    private final boolean sexualMinors;
    private final boolean hateThreatening;
    private final boolean violenceGraphic;
    private final boolean selfHarmIntent;
    private final boolean selfHarmInstructions;
    private final boolean harassmentThreatening;
    private final boolean violence;

    private Categories(Builder builder) {
        this.sexual = builder.sexual;
        this.hate = builder.hate;
        this.harassment = builder.harassment;
        this.selfHarm = builder.selfHarm;
        this.sexualMinors = builder.sexualMinors;
        this.hateThreatening = builder.hateThreatening;
        this.violenceGraphic = builder.violenceGraphic;
        this.selfHarmIntent = builder.selfHarmIntent;
        this.selfHarmInstructions = builder.selfHarmInstructions;
        this.harassmentThreatening = builder.harassmentThreatening;
        this.violence = builder.violence;
    }

    public static Builder builder() {
        return new Builder();
    }

    public boolean isSexual() {
        return this.sexual;
    }

    public boolean isHate() {
        return this.hate;
    }

    public boolean isHarassment() {
        return this.harassment;
    }

    public boolean isSelfHarm() {
        return this.selfHarm;
    }

    public boolean isSexualMinors() {
        return this.sexualMinors;
    }

    public boolean isHateThreatening() {
        return this.hateThreatening;
    }

    public boolean isViolenceGraphic() {
        return this.violenceGraphic;
    }

    public boolean isSelfHarmIntent() {
        return this.selfHarmIntent;
    }

    public boolean isSelfHarmInstructions() {
        return this.selfHarmInstructions;
    }

    public boolean isHarassmentThreatening() {
        return this.harassmentThreatening;
    }

    public boolean isViolence() {
        return this.violence;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Categories)) {
            return false;
        }
        Categories that = (Categories)o;
        return this.sexual == that.sexual && this.hate == that.hate && this.harassment == that.harassment && this.selfHarm == that.selfHarm && this.sexualMinors == that.sexualMinors && this.hateThreatening == that.hateThreatening && this.violenceGraphic == that.violenceGraphic && this.selfHarmIntent == that.selfHarmIntent && this.selfHarmInstructions == that.selfHarmInstructions && this.harassmentThreatening == that.harassmentThreatening && this.violence == that.violence;
    }

    public int hashCode() {
        return Objects.hash(this.sexual, this.hate, this.harassment, this.selfHarm, this.sexualMinors, this.hateThreatening, this.violenceGraphic, this.selfHarmIntent, this.selfHarmInstructions, this.harassmentThreatening, this.violence);
    }

    public String toString() {
        return "Categories{sexual=" + this.sexual + ", hate=" + this.hate + ", harassment=" + this.harassment + ", selfHarm=" + this.selfHarm + ", sexualMinors=" + this.sexualMinors + ", hateThreatening=" + this.hateThreatening + ", violenceGraphic=" + this.violenceGraphic + ", selfHarmIntent=" + this.selfHarmIntent + ", selfHarmInstructions=" + this.selfHarmInstructions + ", harassmentThreatening=" + this.harassmentThreatening + ", violence=" + this.violence + "}";
    }

    public static class Builder {
        private boolean sexual;
        private boolean hate;
        private boolean harassment;
        private boolean selfHarm;
        private boolean sexualMinors;
        private boolean hateThreatening;
        private boolean violenceGraphic;
        private boolean selfHarmIntent;
        private boolean selfHarmInstructions;
        private boolean harassmentThreatening;
        private boolean violence;

        public Builder sexual(boolean sexual) {
            this.sexual = sexual;
            return this;
        }

        public Builder hate(boolean hate) {
            this.hate = hate;
            return this;
        }

        public Builder harassment(boolean harassment) {
            this.harassment = harassment;
            return this;
        }

        public Builder selfHarm(boolean selfHarm) {
            this.selfHarm = selfHarm;
            return this;
        }

        public Builder sexualMinors(boolean sexualMinors) {
            this.sexualMinors = sexualMinors;
            return this;
        }

        public Builder hateThreatening(boolean hateThreatening) {
            this.hateThreatening = hateThreatening;
            return this;
        }

        public Builder violenceGraphic(boolean violenceGraphic) {
            this.violenceGraphic = violenceGraphic;
            return this;
        }

        public Builder selfHarmIntent(boolean selfHarmIntent) {
            this.selfHarmIntent = selfHarmIntent;
            return this;
        }

        public Builder selfHarmInstructions(boolean selfHarmInstructions) {
            this.selfHarmInstructions = selfHarmInstructions;
            return this;
        }

        public Builder harassmentThreatening(boolean harassmentThreatening) {
            this.harassmentThreatening = harassmentThreatening;
            return this;
        }

        public Builder violence(boolean violence) {
            this.violence = violence;
            return this;
        }

        public Categories build() {
            return new Categories(this);
        }
    }
}

