/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.model.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.model.AbstractToolCallSupport;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.ai.chat.model.Generation;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.model.ModelOptionsUtils;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.model.function.FunctionCallbackResolver;
import org.springframework.ai.model.function.FunctionCallingOptions;
import org.springframework.util.CollectionUtils;
import reactor.core.publisher.Flux;

@Deprecated
public class FunctionCallingHelper
extends AbstractToolCallSupport {
    public FunctionCallingHelper() {
        this(null, FunctionCallingOptions.builder().build(), List.of());
    }

    public FunctionCallingHelper(FunctionCallbackResolver functionCallbackResolver, FunctionCallingOptions functionCallingOptions, List<FunctionCallback> toolFunctionCallbacks) {
        super(functionCallbackResolver, functionCallingOptions, toolFunctionCallbacks);
    }

    @Override
    public boolean isToolCall(ChatResponse chatResponse, Set<String> toolCallFinishReasons) {
        return super.isToolCall(chatResponse, toolCallFinishReasons);
    }

    @Override
    public List<Message> buildToolCallConversation(List<Message> previousMessages, AssistantMessage assistantMessage, ToolResponseMessage toolResponseMessage) {
        return super.buildToolCallConversation(previousMessages, assistantMessage, toolResponseMessage);
    }

    @Override
    public List<Message> handleToolCalls(Prompt prompt, ChatResponse response) {
        return super.handleToolCalls(prompt, response);
    }

    public Flux<ChatResponse> processStream(ChatModel chatModel, Prompt prompt, Set<String> finishReasons, Function<AssistantMessage.ToolCall, String> customFunction) {
        Flux<ChatResponse> chatResponses = chatModel.stream(prompt);
        return chatResponses.flatMap(chatResponse -> {
            boolean isToolCall = this.isToolCall((ChatResponse)chatResponse, finishReasons);
            if (isToolCall) {
                Optional<Generation> toolCallGeneration = chatResponse.getResults().stream().filter(g -> !CollectionUtils.isEmpty(g.getOutput().getToolCalls())).findFirst();
                AssistantMessage assistantMessage = toolCallGeneration.get().getOutput();
                ArrayList<ToolResponseMessage.ToolResponse> toolResponses = new ArrayList<ToolResponseMessage.ToolResponse>();
                for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
                    String functionResponse = (String)customFunction.apply(toolCall);
                    toolResponses.add(new ToolResponseMessage.ToolResponse(toolCall.id(), toolCall.name(), ModelOptionsUtils.toJsonString(functionResponse)));
                }
                ToolResponseMessage toolMessageResponse = new ToolResponseMessage(toolResponses, Map.of());
                List<Message> toolCallConversation = this.buildToolCallConversation((List<Message>)prompt.getInstructions(), assistantMessage, toolMessageResponse);
                Prompt prompt2 = new Prompt(toolCallConversation, prompt.getOptions());
                return this.processStream(chatModel, prompt2, finishReasons, customFunction);
            }
            return Flux.just((Object)chatResponse);
        });
    }

    public ChatResponse processCall(ChatModel chatModel, Prompt prompt, Set<String> finishReasons, Function<AssistantMessage.ToolCall, String> customFunction) {
        ChatResponse chatResponse = chatModel.call(prompt);
        boolean isToolCall = this.isToolCall(chatResponse, finishReasons);
        if (!isToolCall) {
            return chatResponse;
        }
        Optional<Generation> toolCallGeneration = chatResponse.getResults().stream().filter(g -> !CollectionUtils.isEmpty(g.getOutput().getToolCalls())).findFirst();
        AssistantMessage assistantMessage = toolCallGeneration.get().getOutput();
        ArrayList<ToolResponseMessage.ToolResponse> toolResponses = new ArrayList<ToolResponseMessage.ToolResponse>();
        for (AssistantMessage.ToolCall toolCall : assistantMessage.getToolCalls()) {
            String functionResponse = customFunction.apply(toolCall);
            toolResponses.add(new ToolResponseMessage.ToolResponse(toolCall.id(), toolCall.name(), ModelOptionsUtils.toJsonString(functionResponse)));
        }
        ToolResponseMessage toolMessageResponse = new ToolResponseMessage(toolResponses, Map.of());
        List<Message> toolCallConversation = this.buildToolCallConversation((List<Message>)prompt.getInstructions(), assistantMessage, toolMessageResponse);
        Prompt prompt2 = new Prompt(toolCallConversation, prompt.getOptions());
        return this.processCall(chatModel, prompt2, finishReasons, customFunction);
    }

    public record FunctionDefinition(String name, String description, String inputTypeSchema) implements FunctionCallback
    {
        @Override
        public String getName() {
            return this.name();
        }

        @Override
        public String getDescription() {
            return this.description();
        }

        @Override
        public String getInputTypeSchema() {
            return this.inputTypeSchema();
        }

        @Override
        public String call(String functionInput) {
            throw new UnsupportedOperationException("FunctionDefinition provides only metadata. It doesn't implement the call method.");
        }
    }
}

