/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.embedding;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.springframework.ai.embedding.EmbeddingModel;
import org.springframework.core.io.DefaultResourceLoader;

public abstract class AbstractEmbeddingModel
implements EmbeddingModel {
    private static Map<String, Integer> KNOWN_EMBEDDING_DIMENSIONS = AbstractEmbeddingModel.loadKnownModelDimensions();
    protected final AtomicInteger embeddingDimensions = new AtomicInteger(-1);

    public static int dimensions(EmbeddingModel embeddingModel, String modelName, String dummyContent) {
        if (KNOWN_EMBEDDING_DIMENSIONS.containsKey(modelName)) {
            return KNOWN_EMBEDDING_DIMENSIONS.get(modelName);
        }
        return embeddingModel.embed(dummyContent).length;
    }

    private static Map<String, Integer> loadKnownModelDimensions() {
        try {
            Properties properties = new Properties();
            properties.load(new DefaultResourceLoader().getResource("classpath:/embedding/embedding-model-dimensions.properties").getInputStream());
            return properties.entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> Integer.parseInt(e.getValue().toString())));
        }
        catch (IOException e2) {
            throw new RuntimeException(e2);
        }
    }

    @Override
    public int dimensions() {
        if (this.embeddingDimensions.get() < 0) {
            this.embeddingDimensions.set(AbstractEmbeddingModel.dimensions(this, "Test", "Hello World"));
        }
        return this.embeddingDimensions.get();
    }
}

