/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.prompt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.SystemMessage;
import org.springframework.ai.chat.messages.ToolResponseMessage;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.ModelRequest;
import org.springframework.lang.Nullable;

public class Prompt
implements ModelRequest<List<Message>> {
    private final List<Message> messages;
    @Nullable
    private ChatOptions chatOptions;

    public Prompt(String contents) {
        this((Message)new UserMessage(contents));
    }

    public Prompt(Message message) {
        this(Collections.singletonList(message));
    }

    public Prompt(List<Message> messages) {
        this(messages, null);
    }

    public Prompt(Message ... messages) {
        this(Arrays.asList(messages), null);
    }

    public Prompt(String contents, ChatOptions chatOptions) {
        this((Message)new UserMessage(contents), chatOptions);
    }

    public Prompt(Message message, ChatOptions chatOptions) {
        this(Collections.singletonList(message), chatOptions);
    }

    public Prompt(List<Message> messages, ChatOptions chatOptions) {
        this.messages = messages;
        this.chatOptions = chatOptions;
    }

    public String getContents() {
        StringBuilder sb = new StringBuilder();
        Iterator iterator = this.getInstructions().iterator();
        while (iterator.hasNext()) {
            Message message = (Message)iterator.next();
            sb.append(message.getText());
        }
        return sb.toString();
    }

    @Override
    @Nullable
    public ChatOptions getOptions() {
        return this.chatOptions;
    }

    @Override
    public List<Message> getInstructions() {
        return this.messages;
    }

    public String toString() {
        return "Prompt{messages=" + String.valueOf(this.messages) + ", modelOptions=" + String.valueOf(this.chatOptions) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Prompt)) {
            return false;
        }
        Prompt prompt = (Prompt)o;
        return Objects.equals(this.messages, prompt.messages) && Objects.equals(this.chatOptions, prompt.chatOptions);
    }

    public int hashCode() {
        return Objects.hash(this.messages, this.chatOptions);
    }

    public Prompt copy() {
        return new Prompt(this.instructionsCopy(), null == this.chatOptions ? null : (ChatOptions)this.chatOptions.copy());
    }

    private List<Message> instructionsCopy() {
        ArrayList<Message> messagesCopy = new ArrayList<Message>();
        this.messages.forEach(message -> {
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                messagesCopy.add(new UserMessage(userMessage.getText(), userMessage.getMedia(), message.getMetadata()));
            } else if (message instanceof SystemMessage) {
                SystemMessage systemMessage = (SystemMessage)message;
                messagesCopy.add(new SystemMessage(systemMessage.getText()));
            } else if (message instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                messagesCopy.add(new AssistantMessage(assistantMessage.getText(), assistantMessage.getMetadata(), assistantMessage.getToolCalls()));
            } else if (message instanceof ToolResponseMessage) {
                ToolResponseMessage toolResponseMessage = (ToolResponseMessage)message;
                messagesCopy.add(new ToolResponseMessage(new ArrayList<ToolResponseMessage.ToolResponse>(toolResponseMessage.getResponses()), new HashMap<String, Object>(toolResponseMessage.getMetadata())));
            } else {
                throw new IllegalArgumentException("Unsupported message type: " + message.getClass().getName());
            }
        });
        return messagesCopy;
    }
}

