/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.metadata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import java.util.Objects;
import org.springframework.ai.chat.metadata.Usage;

@JsonPropertyOrder(value={"promptTokens", "completionTokens", "totalTokens", "generationTokens", "nativeUsage"})
public class DefaultUsage
implements Usage {
    private final Integer promptTokens;
    private final Integer completionTokens;
    @Deprecated(forRemoval=true, since="1.0.0-M6")
    private final Long generationTokens;
    private final int totalTokens;
    private final Object nativeUsage;

    public DefaultUsage(Integer promptTokens, Integer completionTokens, Integer totalTokens, Object nativeUsage) {
        this.promptTokens = promptTokens != null ? promptTokens : 0;
        this.completionTokens = completionTokens != null ? completionTokens : 0;
        this.generationTokens = (long)this.completionTokens;
        this.totalTokens = totalTokens != null ? totalTokens : this.calculateTotalTokens(this.promptTokens, this.completionTokens);
        this.nativeUsage = nativeUsage;
    }

    public DefaultUsage(Integer promptTokens, Integer completionTokens) {
        this(promptTokens, completionTokens, null, null);
    }

    public DefaultUsage(Integer promptTokens, Integer completionTokens, Integer totalTokens) {
        this(promptTokens, completionTokens, totalTokens, null);
    }

    @JsonCreator
    public static DefaultUsage fromJson(@JsonProperty(value="promptTokens") Integer promptTokens, @JsonProperty(value="completionTokens") Integer completionTokens, @JsonProperty(value="generationTokens") Long generationTokens, @JsonProperty(value="totalTokens") Integer totalTokens, @JsonProperty(value="nativeUsage") Object nativeUsage) {
        Integer effectiveCompletionTokens = completionTokens != null ? completionTokens : (generationTokens != null ? generationTokens.intValue() : 0);
        return new DefaultUsage(promptTokens, effectiveCompletionTokens, totalTokens, nativeUsage);
    }

    @Override
    @JsonProperty(value="promptTokens")
    public Integer getPromptTokens() {
        return this.promptTokens;
    }

    @Override
    @JsonProperty(value="completionTokens")
    public Integer getCompletionTokens() {
        return this.completionTokens;
    }

    @Override
    @JsonProperty(value="totalTokens")
    public Integer getTotalTokens() {
        return this.totalTokens;
    }

    @Override
    @JsonProperty(value="nativeUsage")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Object getNativeUsage() {
        return this.nativeUsage;
    }

    private Integer calculateTotalTokens(Integer promptTokens, Integer completionTokens) {
        return promptTokens + completionTokens;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultUsage that = (DefaultUsage)o;
        return this.totalTokens == that.totalTokens && Objects.equals(this.promptTokens, that.promptTokens) && Objects.equals(this.completionTokens, that.completionTokens) && Objects.equals(this.nativeUsage, that.nativeUsage);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.promptTokens);
        result = 31 * result + Objects.hashCode(this.completionTokens);
        result = 31 * result + this.totalTokens;
        result = 31 * result + Objects.hashCode(this.nativeUsage);
        return result;
    }

    public String toString() {
        return "DefaultUsage{promptTokens=" + this.promptTokens + ", completionTokens=" + this.completionTokens + ", totalTokens=" + this.totalTokens + "}";
    }
}

