/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.messages;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;

public abstract class AbstractMessage
implements Message {
    public static final String MESSAGE_TYPE = "messageType";
    protected final MessageType messageType;
    protected final String textContent;
    protected final Map<String, Object> metadata;

    protected AbstractMessage(MessageType messageType, String textContent, Map<String, Object> metadata) {
        Assert.notNull((Object)((Object)messageType), (String)"Message type must not be null");
        if (messageType == MessageType.SYSTEM || messageType == MessageType.USER) {
            Assert.notNull((Object)textContent, (String)"Content must not be null for SYSTEM or USER messages");
        }
        this.messageType = messageType;
        this.textContent = textContent;
        this.metadata = new HashMap<String, Object>(metadata);
        this.metadata.put(MESSAGE_TYPE, (Object)messageType);
    }

    protected AbstractMessage(MessageType messageType, Resource resource, Map<String, Object> metadata) {
        Assert.notNull((Object)resource, (String)"Resource must not be null");
        try (InputStream inputStream = resource.getInputStream();){
            this.textContent = StreamUtils.copyToString((InputStream)inputStream, (Charset)Charset.defaultCharset());
        }
        catch (IOException ex) {
            throw new RuntimeException("Failed to read resource", ex);
        }
        this.messageType = messageType;
        this.metadata = new HashMap<String, Object>(metadata);
        this.metadata.put(MESSAGE_TYPE, (Object)messageType);
    }

    @Override
    public String getText() {
        return this.textContent;
    }

    @Override
    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    @Override
    public MessageType getMessageType() {
        return this.messageType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractMessage)) {
            return false;
        }
        AbstractMessage that = (AbstractMessage)o;
        return this.messageType == that.messageType && Objects.equals(this.textContent, that.textContent) && Objects.equals(this.metadata, that.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.messageType, this.textContent, this.metadata});
    }
}

