/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor.api;

import java.util.function.Predicate;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisor;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.model.ChatResponse;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;

public interface BaseAdvisor
extends CallAroundAdvisor,
StreamAroundAdvisor {
    public static final Scheduler DEFAULT_SCHEDULER = Schedulers.boundedElastic();

    @Override
    default public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
        Assert.notNull((Object)advisedRequest, (String)"advisedRequest cannot be null");
        Assert.notNull((Object)chain, (String)"chain cannot be null");
        AdvisedRequest processedAdvisedRequest = this.before(advisedRequest);
        AdvisedResponse advisedResponse = chain.nextAroundCall(processedAdvisedRequest);
        return this.after(advisedResponse);
    }

    @Override
    default public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
        Assert.notNull((Object)advisedRequest, (String)"advisedRequest cannot be null");
        Assert.notNull((Object)chain, (String)"chain cannot be null");
        Assert.notNull((Object)this.getScheduler(), (String)"scheduler cannot be null");
        Flux advisedResponses = Mono.just((Object)advisedRequest).publishOn(this.getScheduler()).map(this::before).flatMapMany(chain::nextAroundStream);
        return advisedResponses.map(ar -> {
            if (this.onFinishReason().test((AdvisedResponse)ar)) {
                ar = this.after((AdvisedResponse)ar);
            }
            return ar;
        }).onErrorResume(error -> Flux.error((Throwable)new IllegalStateException("Stream processing failed", (Throwable)error)));
    }

    private Predicate<AdvisedResponse> onFinishReason() {
        return advisedResponse -> {
            ChatResponse chatResponse = advisedResponse.response();
            return chatResponse != null && chatResponse.getResults() != null && chatResponse.getResults().stream().anyMatch(result -> result != null && result.getMetadata() != null && StringUtils.hasText((String)result.getMetadata().getFinishReason()));
        };
    }

    @Override
    default public String getName() {
        return this.getClass().getSimpleName();
    }

    public AdvisedRequest before(AdvisedRequest var1);

    public AdvisedResponse after(AdvisedResponse var1);

    default public Scheduler getScheduler() {
        return DEFAULT_SCHEDULER;
    }
}

