/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.ai.chat.client.advisor.AbstractChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.MessageType;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.MessageAggregator;
import org.springframework.ai.document.Document;
import org.springframework.ai.vectorstore.SearchRequest;
import org.springframework.ai.vectorstore.VectorStore;
import org.springframework.util.StringUtils;
import reactor.core.publisher.Flux;

public class VectorStoreChatMemoryAdvisor
extends AbstractChatMemoryAdvisor<VectorStore> {
    private static final String DOCUMENT_METADATA_CONVERSATION_ID = "conversationId";
    private static final String DOCUMENT_METADATA_MESSAGE_TYPE = "messageType";
    private static final String DEFAULT_SYSTEM_TEXT_ADVISE = "\nUse the long term conversation memory from the LONG_TERM_MEMORY section to provide accurate answers.\n\n---------------------\nLONG_TERM_MEMORY:\n{long_term_memory}\n---------------------\n";
    private final String systemTextAdvise;

    @Deprecated(forRemoval=true, since="1.0.0-M6")
    public VectorStoreChatMemoryAdvisor(VectorStore vectorStore) {
        this(vectorStore, DEFAULT_SYSTEM_TEXT_ADVISE);
    }

    @Deprecated(forRemoval=true, since="1.0.0-M6")
    public VectorStoreChatMemoryAdvisor(VectorStore vectorStore, String systemTextAdvise) {
        super(vectorStore);
        this.systemTextAdvise = systemTextAdvise;
    }

    @Deprecated(forRemoval=true, since="1.0.0-M6")
    public VectorStoreChatMemoryAdvisor(VectorStore vectorStore, String defaultConversationId, int chatHistoryWindowSize) {
        this(vectorStore, defaultConversationId, chatHistoryWindowSize, DEFAULT_SYSTEM_TEXT_ADVISE);
    }

    @Deprecated(forRemoval=true, since="1.0.0-M6")
    public VectorStoreChatMemoryAdvisor(VectorStore vectorStore, String defaultConversationId, int chatHistoryWindowSize, int order) {
        this(vectorStore, defaultConversationId, chatHistoryWindowSize, DEFAULT_SYSTEM_TEXT_ADVISE, order);
    }

    @Deprecated(forRemoval=true, since="1.0.0-M6")
    public VectorStoreChatMemoryAdvisor(VectorStore vectorStore, String defaultConversationId, int chatHistoryWindowSize, String systemTextAdvise) {
        this(vectorStore, defaultConversationId, chatHistoryWindowSize, systemTextAdvise, -2147482648);
    }

    private VectorStoreChatMemoryAdvisor(VectorStore vectorStore, String defaultConversationId, int chatHistoryWindowSize, String systemTextAdvise, int order) {
        super(vectorStore, defaultConversationId, chatHistoryWindowSize, true, order);
        this.systemTextAdvise = systemTextAdvise;
    }

    public static Builder builder(VectorStore chatMemory) {
        return new Builder(chatMemory);
    }

    @Override
    public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
        advisedRequest = this.before(advisedRequest);
        AdvisedResponse advisedResponse = chain.nextAroundCall(advisedRequest);
        this.observeAfter(advisedResponse);
        return advisedResponse;
    }

    @Override
    public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
        Flux<AdvisedResponse> advisedResponses = this.doNextWithProtectFromBlockingBefore(advisedRequest, chain, this::before);
        return new MessageAggregator().aggregateAdvisedResponse(advisedResponses, this::observeAfter);
    }

    private AdvisedRequest before(AdvisedRequest request) {
        Object advisedSystemText = StringUtils.hasText((String)request.systemText()) ? request.systemText() + System.lineSeparator() + this.systemTextAdvise : this.systemTextAdvise;
        SearchRequest searchRequest = SearchRequest.builder().query(request.userText()).topK(this.doGetChatMemoryRetrieveSize(request.adviseContext())).filterExpression("conversationId=='" + this.doGetConversationId(request.adviseContext()) + "'").build();
        List<Document> documents = ((VectorStore)this.getChatMemoryStore()).similaritySearch(searchRequest);
        String longTermMemory = documents.stream().map(Document::getText).collect(Collectors.joining(System.lineSeparator()));
        HashMap<String, Object> advisedSystemParams = new HashMap<String, Object>(request.systemParams());
        advisedSystemParams.put("long_term_memory", longTermMemory);
        AdvisedRequest advisedRequest = AdvisedRequest.from(request).systemText((String)advisedSystemText).systemParams(advisedSystemParams).build();
        UserMessage userMessage = new UserMessage(request.userText(), request.media());
        ((VectorStore)this.getChatMemoryStore()).write(this.toDocuments(List.of(userMessage), this.doGetConversationId(request.adviseContext())));
        return advisedRequest;
    }

    private void observeAfter(AdvisedResponse advisedResponse) {
        List<Message> assistantMessages = advisedResponse.response().getResults().stream().map(g -> g.getOutput()).toList();
        ((VectorStore)this.getChatMemoryStore()).write(this.toDocuments(assistantMessages, this.doGetConversationId(advisedResponse.adviseContext())));
    }

    private List<Document> toDocuments(List<Message> messages, String conversationId) {
        List<Document> docs = messages.stream().filter(m -> m.getMessageType() == MessageType.USER || m.getMessageType() == MessageType.ASSISTANT).map(message -> {
            HashMap<String, Object> metadata = new HashMap<String, Object>(message.getMetadata() != null ? message.getMetadata() : new HashMap());
            metadata.put(DOCUMENT_METADATA_CONVERSATION_ID, conversationId);
            metadata.put(DOCUMENT_METADATA_MESSAGE_TYPE, message.getMessageType().name());
            if (message instanceof UserMessage) {
                UserMessage userMessage = (UserMessage)message;
                return Document.builder().text(userMessage.getText()).metadata(metadata).build();
            }
            if (message instanceof AssistantMessage) {
                AssistantMessage assistantMessage = (AssistantMessage)message;
                return Document.builder().text(assistantMessage.getText()).metadata(metadata).build();
            }
            throw new RuntimeException("Unknown message type: " + String.valueOf((Object)message.getMessageType()));
        }).toList();
        return docs;
    }

    public static class Builder
    extends AbstractChatMemoryAdvisor.AbstractBuilder<VectorStore> {
        private String systemTextAdvise = "\nUse the long term conversation memory from the LONG_TERM_MEMORY section to provide accurate answers.\n\n---------------------\nLONG_TERM_MEMORY:\n{long_term_memory}\n---------------------\n";

        protected Builder(VectorStore chatMemory) {
            super(chatMemory);
        }

        public Builder systemTextAdvise(String systemTextAdvise) {
            this.systemTextAdvise = systemTextAdvise;
            return this;
        }

        public VectorStoreChatMemoryAdvisor build() {
            return new VectorStoreChatMemoryAdvisor((VectorStore)this.chatMemory, this.conversationId, this.chatMemoryRetrieveSize, this.systemTextAdvise, this.order);
        }
    }
}

