/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client.advisor;

import java.util.ArrayList;
import java.util.List;
import org.springframework.ai.chat.client.advisor.AbstractChatMemoryAdvisor;
import org.springframework.ai.chat.client.advisor.api.AdvisedRequest;
import org.springframework.ai.chat.client.advisor.api.AdvisedResponse;
import org.springframework.ai.chat.client.advisor.api.CallAroundAdvisorChain;
import org.springframework.ai.chat.client.advisor.api.StreamAroundAdvisorChain;
import org.springframework.ai.chat.memory.ChatMemory;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.model.MessageAggregator;
import reactor.core.publisher.Flux;

public class MessageChatMemoryAdvisor
extends AbstractChatMemoryAdvisor<ChatMemory> {
    public MessageChatMemoryAdvisor(ChatMemory chatMemory) {
        super(chatMemory);
    }

    public MessageChatMemoryAdvisor(ChatMemory chatMemory, String defaultConversationId, int chatHistoryWindowSize) {
        this(chatMemory, defaultConversationId, chatHistoryWindowSize, -2147482648);
    }

    public MessageChatMemoryAdvisor(ChatMemory chatMemory, String defaultConversationId, int chatHistoryWindowSize, int order) {
        super(chatMemory, defaultConversationId, chatHistoryWindowSize, true, order);
    }

    public static Builder builder(ChatMemory chatMemory) {
        return new Builder(chatMemory);
    }

    @Override
    public AdvisedResponse aroundCall(AdvisedRequest advisedRequest, CallAroundAdvisorChain chain) {
        advisedRequest = this.before(advisedRequest);
        AdvisedResponse advisedResponse = chain.nextAroundCall(advisedRequest);
        this.observeAfter(advisedResponse);
        return advisedResponse;
    }

    @Override
    public Flux<AdvisedResponse> aroundStream(AdvisedRequest advisedRequest, StreamAroundAdvisorChain chain) {
        Flux<AdvisedResponse> advisedResponses = this.doNextWithProtectFromBlockingBefore(advisedRequest, chain, this::before);
        return new MessageAggregator().aggregateAdvisedResponse(advisedResponses, this::observeAfter);
    }

    private AdvisedRequest before(AdvisedRequest request) {
        String conversationId = this.doGetConversationId(request.adviseContext());
        int chatMemoryRetrieveSize = this.doGetChatMemoryRetrieveSize(request.adviseContext());
        List<Message> memoryMessages = ((ChatMemory)this.getChatMemoryStore()).get(conversationId, chatMemoryRetrieveSize);
        ArrayList<Message> advisedMessages = new ArrayList<Message>(request.messages());
        advisedMessages.addAll(memoryMessages);
        AdvisedRequest advisedRequest = AdvisedRequest.from(request).messages(advisedMessages).build();
        UserMessage userMessage = new UserMessage(request.userText(), request.media());
        ((ChatMemory)this.getChatMemoryStore()).add(this.doGetConversationId(request.adviseContext()), userMessage);
        return advisedRequest;
    }

    private void observeAfter(AdvisedResponse advisedResponse) {
        List<Message> assistantMessages = advisedResponse.response().getResults().stream().map(g -> g.getOutput()).toList();
        ((ChatMemory)this.getChatMemoryStore()).add(this.doGetConversationId(advisedResponse.adviseContext()), assistantMessages);
    }

    public static class Builder
    extends AbstractChatMemoryAdvisor.AbstractBuilder<ChatMemory> {
        protected Builder(ChatMemory chatMemory) {
            super(chatMemory);
        }

        public MessageChatMemoryAdvisor build() {
            return new MessageChatMemoryAdvisor((ChatMemory)this.chatMemory, this.conversationId, this.chatMemoryRetrieveSize, this.order);
        }
    }
}

