/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ai.chat.client;

import io.micrometer.observation.ObservationRegistry;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.client.DefaultChatClient;
import org.springframework.ai.chat.client.advisor.api.Advisor;
import org.springframework.ai.chat.client.observation.ChatClientObservationConvention;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.model.ChatModel;
import org.springframework.ai.chat.model.ToolContext;
import org.springframework.ai.chat.prompt.ChatOptions;
import org.springframework.ai.model.function.FunctionCallback;
import org.springframework.ai.tool.ToolCallback;
import org.springframework.ai.tool.ToolCallbackProvider;
import org.springframework.core.io.Resource;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class DefaultChatClientBuilder
implements ChatClient.Builder {
    protected final DefaultChatClient.DefaultChatClientRequestSpec defaultRequest;

    DefaultChatClientBuilder(ChatModel chatModel) {
        this(chatModel, ObservationRegistry.NOOP, null);
    }

    public DefaultChatClientBuilder(ChatModel chatModel, ObservationRegistry observationRegistry, @Nullable ChatClientObservationConvention customObservationConvention) {
        Assert.notNull((Object)chatModel, (String)("the " + ChatModel.class.getName() + " must be non-null"));
        Assert.notNull((Object)observationRegistry, (String)("the " + ObservationRegistry.class.getName() + " must be non-null"));
        this.defaultRequest = new DefaultChatClient.DefaultChatClientRequestSpec(chatModel, null, Map.of(), null, Map.of(), List.of(), List.of(), List.of(), List.of(), null, List.of(), Map.of(), observationRegistry, customObservationConvention, Map.of());
    }

    @Override
    public ChatClient build() {
        return new DefaultChatClient(this.defaultRequest);
    }

    @Override
    public ChatClient.Builder clone() {
        return this.defaultRequest.mutate();
    }

    @Override
    public ChatClient.Builder defaultAdvisors(Advisor ... advisors) {
        this.defaultRequest.advisors(advisors);
        return this;
    }

    @Override
    public ChatClient.Builder defaultAdvisors(Consumer<ChatClient.AdvisorSpec> advisorSpecConsumer) {
        this.defaultRequest.advisors(advisorSpecConsumer);
        return this;
    }

    @Override
    public ChatClient.Builder defaultAdvisors(List<Advisor> advisors) {
        this.defaultRequest.advisors(advisors);
        return this;
    }

    @Override
    public ChatClient.Builder defaultOptions(ChatOptions chatOptions) {
        this.defaultRequest.options(chatOptions);
        return this;
    }

    @Override
    public ChatClient.Builder defaultUser(String text) {
        this.defaultRequest.user(text);
        return this;
    }

    @Override
    public ChatClient.Builder defaultUser(Resource text, Charset charset) {
        Assert.notNull((Object)text, (String)"text cannot be null");
        Assert.notNull((Object)charset, (String)"charset cannot be null");
        try {
            this.defaultRequest.user(text.getContentAsString(charset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public ChatClient.Builder defaultUser(Resource text) {
        return this.defaultUser(text, Charset.defaultCharset());
    }

    @Override
    public ChatClient.Builder defaultUser(Consumer<ChatClient.PromptUserSpec> userSpecConsumer) {
        this.defaultRequest.user(userSpecConsumer);
        return this;
    }

    @Override
    public ChatClient.Builder defaultSystem(String text) {
        this.defaultRequest.system(text);
        return this;
    }

    @Override
    public ChatClient.Builder defaultSystem(Resource text, Charset charset) {
        Assert.notNull((Object)text, (String)"text cannot be null");
        Assert.notNull((Object)charset, (String)"charset cannot be null");
        try {
            this.defaultRequest.system(text.getContentAsString(charset));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    @Override
    public ChatClient.Builder defaultSystem(Resource text) {
        return this.defaultSystem(text, Charset.defaultCharset());
    }

    @Override
    public ChatClient.Builder defaultSystem(Consumer<ChatClient.PromptSystemSpec> systemSpecConsumer) {
        this.defaultRequest.system(systemSpecConsumer);
        return this;
    }

    @Override
    public ChatClient.Builder defaultTools(String ... toolNames) {
        this.defaultRequest.tools(toolNames);
        return this;
    }

    @Override
    public ChatClient.Builder defaultTools(FunctionCallback ... toolCallbacks) {
        this.defaultRequest.tools(toolCallbacks);
        return this;
    }

    @Override
    public ChatClient.Builder defaultTools(List<ToolCallback> toolCallbacks) {
        this.defaultRequest.tools(toolCallbacks);
        return this;
    }

    @Override
    public ChatClient.Builder defaultTools(Object ... toolObjects) {
        this.defaultRequest.tools(toolObjects);
        return this;
    }

    @Override
    public ChatClient.Builder defaultTools(ToolCallbackProvider ... toolCallbackProviders) {
        this.defaultRequest.tools(toolCallbackProviders);
        return this;
    }

    @Deprecated
    public <I, O> ChatClient.Builder defaultFunction(String name, String description, Function<I, O> function) {
        this.defaultRequest.functions(((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(name, function).description(description)).build());
        return this;
    }

    @Deprecated
    public <I, O> ChatClient.Builder defaultFunction(String name, String description, BiFunction<I, ToolContext, O> biFunction) {
        this.defaultRequest.functions(((FunctionCallback.FunctionInvokingSpec)FunctionCallback.builder().function(name, biFunction).description(description)).build());
        return this;
    }

    @Override
    @Deprecated
    public ChatClient.Builder defaultFunctions(String ... functionNames) {
        this.defaultRequest.functions(functionNames);
        return this;
    }

    @Override
    @Deprecated
    public ChatClient.Builder defaultFunctions(FunctionCallback ... functionCallbacks) {
        this.defaultRequest.functions(functionCallbacks);
        return this;
    }

    @Override
    public ChatClient.Builder defaultToolContext(Map<String, Object> toolContext) {
        this.defaultRequest.toolContext(toolContext);
        return this;
    }

    void addMessages(List<Message> messages) {
        this.defaultRequest.messages(messages);
    }

    void addToolCallbacks(List<FunctionCallback> toolCallbacks) {
        Assert.notNull(toolCallbacks, (String)"toolCallbacks cannot be null");
        this.defaultRequest.tools((FunctionCallback[])toolCallbacks.toArray(FunctionCallback[]::new));
    }

    void addToolContext(Map<String, Object> toolContext) {
        this.defaultRequest.toolContext(toolContext);
    }
}

