/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.json.impl;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.nutz.json.AbstractJsonEntityFieldMaker;
import org.nutz.json.JsonException;
import org.nutz.json.JsonField;
import org.nutz.json.entity.JsonEntityField;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.util.Callback;
import org.nutz.lang.util.Callback3;

public class JsonEntityFieldMakerImpl
extends AbstractJsonEntityFieldMaker {
    @Override
    public JsonEntityField make(Mirror<?> mirror, Field field) {
        return JsonEntityField.eval(mirror, field);
    }

    @Override
    public JsonEntityField make(Mirror<?> mirror, final Method method) {
        final JsonField jf = method.getAnnotation(JsonField.class);
        if (null == jf || jf.ignore()) {
            return null;
        }
        final JsonEntityField[] result = new JsonEntityField[1];
        Callback<Method> whenError = new Callback<Method>(){

            @Override
            public void invoke(Method m) {
                throw Lang.makeThrow(JsonException.class, "JsonField '%s' should be getter/setter pair!", m);
            }
        };
        Callback3<String, Method, Method> whenOk = new Callback3<String, Method, Method>(){

            @Override
            public void invoke(String name, Method getter, Method setter) {
                JsonEntityField ef;
                if (null == getter || null == setter || Strings.isBlank(name)) {
                    throw Lang.makeThrow(JsonException.class, "JsonField '%s' should be getter/setter pair!", method);
                }
                result[0] = ef = JsonEntityField.eval(Strings.sBlank(jf.value(), name), getter, setter);
            }
        };
        Mirror.evalGetterSetter(method, whenOk, whenError);
        return result[0];
    }
}

