/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.ioc.impl;

import java.lang.reflect.Method;
import java.util.ArrayList;
import org.nutz.ioc.IocEventTrigger;
import org.nutz.ioc.IocException;
import org.nutz.ioc.IocMaking;
import org.nutz.ioc.ObjectMaker;
import org.nutz.ioc.ObjectProxy;
import org.nutz.ioc.ValueProxy;
import org.nutz.ioc.meta.IocEventSet;
import org.nutz.ioc.meta.IocField;
import org.nutz.ioc.meta.IocObject;
import org.nutz.ioc.trigger.MethodEventTrigger;
import org.nutz.ioc.weaver.DefaultWeaver;
import org.nutz.ioc.weaver.FieldInjector;
import org.nutz.lang.Lang;
import org.nutz.lang.Mirror;
import org.nutz.lang.Strings;
import org.nutz.lang.born.Borning;
import org.nutz.lang.born.MethodBorning;
import org.nutz.lang.born.MethodCastingBorning;

public class ObjectMakerImpl
implements ObjectMaker {
    @Override
    public ObjectProxy make(final IocMaking ing, IocObject iobj) {
        Mirror<?> mirror = ing.getMirrors().getMirror(iobj.getType(), ing.getObjectName());
        IocEventSet iocEventSet = iobj.getEvents();
        ObjectProxy op = new ObjectProxy();
        if (iobj.isSingleton() && null != ing.getObjectName()) {
            ing.getContext().save(iobj.getScope(), ing.getObjectName(), op);
        }
        if (null != iobj.getEvents()) {
            op.setFetch(ObjectMakerImpl.createTrigger(mirror, iocEventSet.getFetch()));
            op.setDepose(ObjectMakerImpl.createTrigger(mirror, iocEventSet.getDepose()));
        }
        try {
            DefaultWeaver dw = new DefaultWeaver();
            op.setWeaver(dw);
            if (null != iobj.getEvents()) {
                dw.setCreate(ObjectMakerImpl.createTrigger(mirror, iocEventSet.getCreate()));
            }
            ValueProxy[] vps = new ValueProxy[Lang.eleSize(iobj.getArgs())];
            for (int i = 0; i < vps.length; ++i) {
                vps[i] = ing.makeValue(iobj.getArgs()[i]);
            }
            dw.setArgs(vps);
            Object[] args = new Object[vps.length];
            boolean hasNullArg = false;
            for (int i = 0; i < args.length; ++i) {
                args[i] = vps[i].get(ing);
                if (args[i] != null) continue;
                hasNullArg = true;
            }
            if (iobj.getFactory() != null) {
                final String[] ss = iobj.getFactory().split("#", 2);
                if (ss[0].startsWith("$")) {
                    dw.setBorning(new Borning<Object>(){

                        @Override
                        public Object born(Object ... args) {
                            Object factoryBean = ing.getIoc().get(null, ss[0].substring(1));
                            return Mirror.me(factoryBean).invoke(factoryBean, ss[1], args);
                        }
                    });
                } else {
                    Method m;
                    Mirror<Class<?>> mi = Mirror.me(Lang.loadClass(ss[0]));
                    if (hasNullArg) {
                        m = (Method)Lang.first(mi.findMethods(ss[1], args.length));
                        if (m == null) {
                            throw new IocException(ing.getObjectName(), "Factory method not found --> ", iobj.getFactory());
                        }
                        dw.setBorning(new MethodCastingBorning(m));
                    } else {
                        m = mi.findMethod(ss[1], args);
                        dw.setBorning(new MethodBorning(m));
                    }
                }
            } else {
                dw.setBorning(mirror.getBorning(args));
            }
            Object obj = null;
            if (iobj.isSingleton()) {
                obj = dw.born(ing);
                op.setObj(obj);
            }
            ArrayList<IocField> _fields = new ArrayList<IocField>(iobj.getFields().values());
            FieldInjector[] fields = new FieldInjector[_fields.size()];
            for (int i = 0; i < fields.length; ++i) {
                IocField ifld = (IocField)_fields.get(i);
                try {
                    ValueProxy vp = ing.makeValue(ifld.getValue());
                    fields[i] = FieldInjector.create(mirror, ifld.getName(), vp, ifld.isOptional());
                    continue;
                }
                catch (Exception e) {
                    throw Lang.wrapThrow(e, "Fail to eval Injector for field: '%s'", ifld.getName());
                }
            }
            dw.setFields(fields);
            if (null != obj) {
                dw.fill(ing, obj);
            }
            dw.onCreate(obj);
        }
        catch (IocException e) {
            ing.getContext().remove(iobj.getScope(), ing.getObjectName());
            e.addBeanNames(ing.getObjectName());
            throw e;
        }
        catch (Throwable e) {
            ing.getContext().remove(iobj.getScope(), ing.getObjectName());
            throw new IocException(ing.getObjectName(), e, "throw Exception when creating", new Object[0]);
        }
        return op;
    }

    private static IocEventTrigger<Object> createTrigger(Mirror<?> mirror, String str) {
        if (Strings.isBlank(str)) {
            return null;
        }
        if (str.contains(".")) {
            try {
                return (IocEventTrigger)((Object)Mirror.me(Lang.loadClass(str)).born(new Object[0]));
            }
            catch (Exception e) {
                throw Lang.wrapThrow(e);
            }
        }
        try {
            return new MethodEventTrigger(mirror.findMethod(str, new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw Lang.wrapThrow(e);
        }
    }
}

