/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.http;

import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nutz.http.HttpReqRespInterceptor;
import org.nutz.http.Request;
import org.nutz.http.Response;
import org.nutz.json.Json;
import org.nutz.lang.Strings;
import org.nutz.lang.meta.Pair;
import org.nutz.log.Log;
import org.nutz.log.Logs;

public class Cookie
implements HttpReqRespInterceptor {
    private static final Log log = Logs.get();
    protected Map<String, String> map = new HashMap<String, String>();
    protected boolean debug;

    public Cookie() {
    }

    public Cookie(String s) {
        this();
        this.parse(s);
    }

    public String get(String name) {
        return this.map.get(name);
    }

    public Cookie remove(String name) {
        this.map.remove(name);
        return this;
    }

    public Cookie set(String name, String value) {
        this.map.put(name, value);
        return this;
    }

    public void parse(String str) {
        String[] ss;
        if (this.debug) {
            log.debug("parse " + str);
        }
        for (String s : ss = Strings.splitIgnoreBlank(str, ";")) {
            long age;
            Pair<String> p = Pair.create(Strings.trim(s));
            if (p.getValueString() == null || "Path".equals(p.getName()) || "Expires".equals(p.getName())) continue;
            if ("Max-Age".equals(p.getName()) && (age = Long.parseLong(p.getValue())) == 0L) {
                return;
            }
            String val = p.getValueString();
            if (this.debug) {
                log.debugf("add cookie [%s=%s]", p.getName(), val);
            }
            this.map.put(p.getName(), val);
        }
    }

    public String toString() {
        if (this.map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> en : this.map.entrySet()) {
            sb.append(en.getKey()).append('=').append(en.getValue()).append("; ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    @Override
    public void beforeConnect(Request request) {
    }

    @Override
    public void afterConnect(Request request, HttpURLConnection conn) {
        if (this.map.isEmpty()) {
            return;
        }
        String c = this.toString();
        if (this.debug) {
            log.debugf("add Cookie for req [%s]", c);
        }
        if (!Strings.isBlank(c)) {
            conn.addRequestProperty("Cookie", c);
        }
    }

    @Override
    public void afterResponse(Request request, HttpURLConnection conn, Response response) {
        Map<String, List<String>> props = conn.getHeaderFields();
        for (Map.Entry<String, List<String>> en : props.entrySet()) {
            if (en.getKey() == null || !en.getKey().equalsIgnoreCase("Set-Cookie")) continue;
            for (String e : en.getValue()) {
                if (this.debug) {
                    log.debugf("found Set-Cookie [%s]", e);
                }
                this.parse(e);
            }
        }
    }

    public String toJson() {
        return Json.toJson(this.map);
    }

    public int size() {
        return this.map.size();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }
}

