/*
 * Decompiled with CFR 0.152.
 */
package org.nutz.dao;

import org.nutz.dao.DB;

public class DatabaseMeta {
    private DB type = DB.OTHER;
    private String version;
    private String productName;

    public String getProductName() {
        return this.productName;
    }

    public String toString() {
        return String.format("%s:[%s - %s]", this.type.name(), this.productName, this.version);
    }

    public void setProductName(String productName) {
        this.productName = productName;
        String proName = productName.toLowerCase();
        this.type = "h2".equals(proName) ? DB.H2 : (proName.startsWith("postgresql") ? DB.PSQL : (proName.startsWith("mysql") ? DB.MYSQL : (proName.startsWith("oracle") ? DB.ORACLE : (proName.startsWith("db2") ? DB.DB2 : (proName.startsWith("microsoft sql") ? DB.SQLSERVER : (proName.startsWith("sqlite") ? DB.SQLITE : (proName.startsWith("hsql") ? DB.HSQL : (proName.contains("derby") ? DB.DERBY : DB.OTHER))))))));
    }

    @Deprecated
    public String getResultSetMetaSql(String tableName) {
        if (this.isMySql() || this.isPostgresql()) {
            return "SELECT * FROM " + tableName + " LIMIT 1";
        }
        if (this.isSqlServer()) {
            return "SELECT TOP 1 * FROM " + tableName;
        }
        return "SELECT * FROM " + tableName;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setAsMysql() {
        this.type = DB.MYSQL;
    }

    public void setAsPsql() {
        this.type = DB.PSQL;
    }

    public void setAsOracle() {
        this.type = DB.ORACLE;
    }

    public void setAsSqlServer() {
        this.type = DB.SQLSERVER;
    }

    public void setAsDB2() {
        this.type = DB.DB2;
    }

    public void setAsSQLite() {
        this.type = DB.SQLITE;
    }

    public void setAsOther() {
        this.type = DB.OTHER;
    }

    public DB getType() {
        return this.type;
    }

    public String getTypeName() {
        return this.type.name();
    }

    public boolean isOther() {
        return DB.OTHER == this.type;
    }

    public boolean isMySql() {
        return DB.MYSQL == this.type;
    }

    public boolean isPostgresql() {
        return DB.PSQL == this.type;
    }

    public boolean isSqlServer() {
        return DB.SQLSERVER == this.type;
    }

    public boolean isOracle() {
        return DB.ORACLE == this.type;
    }

    public boolean isDB2() {
        return DB.DB2 == this.type;
    }

    public boolean isH2() {
        return DB.H2 == this.type;
    }

    public boolean isSQLite() {
        return DB.SQLITE == this.type;
    }

    public boolean isHsql() {
        return DB.HSQL == this.type;
    }

    public boolean isDerby() {
        return DB.DERBY == this.type;
    }
}

