/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.v1;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.async.connection.ChannelAttributes;
import org.neo4j.driver.internal.cursor.AsyncResultCursorOnlyFactory;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.handlers.BeginTxResponseHandler;
import org.neo4j.driver.internal.handlers.CommitTxResponseHandler;
import org.neo4j.driver.internal.handlers.InitResponseHandler;
import org.neo4j.driver.internal.handlers.NoOpResponseHandler;
import org.neo4j.driver.internal.handlers.PullAllResponseHandler;
import org.neo4j.driver.internal.handlers.PullHandlers;
import org.neo4j.driver.internal.handlers.RollbackTxResponseHandler;
import org.neo4j.driver.internal.handlers.RunResponseHandler;
import org.neo4j.driver.internal.messaging.BoltProtocol;
import org.neo4j.driver.internal.messaging.Message;
import org.neo4j.driver.internal.messaging.MessageFormat;
import org.neo4j.driver.internal.messaging.request.InitMessage;
import org.neo4j.driver.internal.messaging.request.MultiDatabaseUtil;
import org.neo4j.driver.internal.messaging.request.PullAllMessage;
import org.neo4j.driver.internal.messaging.request.RunMessage;
import org.neo4j.driver.internal.messaging.v1.MessageFormatV1;
import org.neo4j.driver.internal.shaded.io.netty.channel.Channel;
import org.neo4j.driver.internal.shaded.io.netty.channel.ChannelPromise;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.util.Futures;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.util.MetadataExtractor;

public class BoltProtocolV1
implements BoltProtocol {
    public static final int VERSION = 1;
    public static final BoltProtocol INSTANCE = new BoltProtocolV1();
    public static final MetadataExtractor METADATA_EXTRACTOR = new MetadataExtractor("result_available_after", "result_consumed_after");
    private static final String BEGIN_QUERY = "BEGIN";
    private static final Message BEGIN_MESSAGE = new RunMessage("BEGIN");
    private static final Message COMMIT_MESSAGE = new RunMessage("COMMIT");
    private static final Message ROLLBACK_MESSAGE = new RunMessage("ROLLBACK");

    @Override
    public MessageFormat createMessageFormat() {
        return new MessageFormatV1();
    }

    @Override
    public void initializeChannel(String userAgent, Map<String, Value> authToken, ChannelPromise channelInitializedPromise) {
        Channel channel = channelInitializedPromise.channel();
        InitMessage message = new InitMessage(userAgent, authToken);
        InitResponseHandler handler = new InitResponseHandler(channelInitializedPromise);
        ChannelAttributes.messageDispatcher(channel).enqueue(handler);
        channel.writeAndFlush(message, channel.voidPromise());
    }

    @Override
    public void prepareToCloseChannel(Channel channel) {
    }

    @Override
    public CompletionStage<Void> beginTransaction(Connection connection, Bookmark bookmark, TransactionConfig config) {
        try {
            this.verifyBeforeTransaction(config, connection.databaseName());
        }
        catch (Exception error) {
            return Futures.failedFuture(error);
        }
        if (bookmark.isEmpty()) {
            connection.write(BEGIN_MESSAGE, NoOpResponseHandler.INSTANCE, PullAllMessage.PULL_ALL, NoOpResponseHandler.INSTANCE);
            return Futures.completedWithNull();
        }
        CompletableFuture<Void> beginTxFuture = new CompletableFuture<Void>();
        connection.writeAndFlush(new RunMessage(BEGIN_QUERY, SingleBookmarkHelper.asBeginTransactionParameters(bookmark)), NoOpResponseHandler.INSTANCE, PullAllMessage.PULL_ALL, new BeginTxResponseHandler(beginTxFuture));
        return beginTxFuture;
    }

    @Override
    public CompletionStage<Bookmark> commitTransaction(Connection connection) {
        CompletableFuture<Bookmark> commitFuture = new CompletableFuture<Bookmark>();
        CommitTxResponseHandler pullAllHandler = new CommitTxResponseHandler(commitFuture);
        connection.writeAndFlush(COMMIT_MESSAGE, NoOpResponseHandler.INSTANCE, PullAllMessage.PULL_ALL, pullAllHandler);
        return commitFuture;
    }

    @Override
    public CompletionStage<Void> rollbackTransaction(Connection connection) {
        CompletableFuture<Void> rollbackFuture = new CompletableFuture<Void>();
        RollbackTxResponseHandler pullAllHandler = new RollbackTxResponseHandler(rollbackFuture);
        connection.writeAndFlush(ROLLBACK_MESSAGE, NoOpResponseHandler.INSTANCE, PullAllMessage.PULL_ALL, pullAllHandler);
        return rollbackFuture;
    }

    @Override
    public ResultCursorFactory runInAutoCommitTransaction(Connection connection, Query query, BookmarkHolder bookmarkHolder, TransactionConfig config, boolean waitForRunResponse, long ignored) {
        this.verifyBeforeTransaction(config, connection.databaseName());
        return BoltProtocolV1.buildResultCursorFactory(connection, query, null, waitForRunResponse);
    }

    @Override
    public ResultCursorFactory runInUnmanagedTransaction(Connection connection, Query query, UnmanagedTransaction tx, boolean waitForRunResponse, long ignored) {
        return BoltProtocolV1.buildResultCursorFactory(connection, query, tx, waitForRunResponse);
    }

    @Override
    public int version() {
        return 1;
    }

    private static ResultCursorFactory buildResultCursorFactory(Connection connection, Query query, UnmanagedTransaction tx, boolean waitForRunResponse) {
        String queryText = query.text();
        Map<String, Value> params = query.parameters().asMap(Values.ofValue());
        RunMessage runMessage = new RunMessage(queryText, params);
        RunResponseHandler runHandler = new RunResponseHandler(METADATA_EXTRACTOR);
        PullAllResponseHandler pullAllHandler = PullHandlers.newBoltV1PullAllHandler(query, runHandler, connection, tx);
        return new AsyncResultCursorOnlyFactory(connection, runMessage, runHandler, pullAllHandler, waitForRunResponse);
    }

    private void verifyBeforeTransaction(TransactionConfig config, DatabaseName databaseName) {
        if (config != null && !config.isEmpty()) {
            throw BoltProtocolV1.txConfigNotSupported();
        }
        MultiDatabaseUtil.assertEmptyDatabaseName(databaseName, this.version());
    }

    private static ClientException txConfigNotSupported() {
        return new ClientException("Driver is connected to the database that does not support transaction configuration. Please upgrade to neo4j 3.5.0 or later in order to use this functionality");
    }

    static class SingleBookmarkHelper {
        private static final String BOOKMARK_PREFIX = "neo4j:bookmark:v1:tx";
        private static final long UNKNOWN_BOOKMARK_VALUE = -1L;

        SingleBookmarkHelper() {
        }

        static Map<String, Value> asBeginTransactionParameters(Bookmark bookmark) {
            if (bookmark.isEmpty()) {
                return Collections.emptyMap();
            }
            HashMap<String, Value> parameters = Iterables.newHashMapWithSize(1);
            parameters.put("bookmark", Values.value(SingleBookmarkHelper.maxBookmark(bookmark.values())));
            parameters.put("bookmarks", Values.value(bookmark.values()));
            return parameters;
        }

        private static String maxBookmark(Iterable<String> bookmarks) {
            if (bookmarks == null) {
                return null;
            }
            Iterator<String> iterator = bookmarks.iterator();
            if (!iterator.hasNext()) {
                return null;
            }
            String maxBookmark = iterator.next();
            long maxValue = SingleBookmarkHelper.bookmarkValue(maxBookmark);
            while (iterator.hasNext()) {
                String bookmark = iterator.next();
                long value = SingleBookmarkHelper.bookmarkValue(bookmark);
                if (value <= maxValue) continue;
                maxBookmark = bookmark;
                maxValue = value;
            }
            return maxBookmark;
        }

        private static long bookmarkValue(String value) {
            if (value != null && value.startsWith(BOOKMARK_PREFIX)) {
                try {
                    return Long.parseLong(value.substring(BOOKMARK_PREFIX.length()));
                }
                catch (NumberFormatException e) {
                    return -1L;
                }
            }
            return -1L;
        }
    }
}

