/*
 * Copyright (c) 2002-2018 "Neo4j,"
 * Neo4j Sweden AB [http://neo4j.com]
 *
 * This file is part of Neo4j.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.neo4j.driver.internal.cluster;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashSet;
import java.util.Set;

import org.neo4j.driver.internal.BoltServerAddress;
import org.neo4j.driver.v1.Logger;

public class DnsResolver implements HostNameResolver
{
    private final Logger logger;

    public DnsResolver( Logger logger )
    {
        this.logger = logger;
    }

    @Override
    public Set<BoltServerAddress> resolve( BoltServerAddress initialRouter )
    {
        Set<BoltServerAddress> addresses = new HashSet<>();
        try
        {
            InetAddress[] ipAddresses = InetAddress.getAllByName( initialRouter.host() );

            for ( InetAddress ipAddress : ipAddresses )
            {
                addresses.add( new BoltServerAddress( ipAddress.getHostAddress(), initialRouter.port() ) );
            }

            return addresses;
        }
        catch ( UnknownHostException e )
        {
            logger.error( "Failed to resolve URI `" + initialRouter + "` to IPs due to error: " + e.getMessage(), e );

            addresses.add( initialRouter );
            return addresses;
        }
    }
}
