/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.scalecube.rpc;

import io.netty.util.concurrent.FastThreadLocal;
import io.scalecube.services.api.ErrorData;
import io.scalecube.services.api.ServiceMessage;
import io.scalecube.services.exceptions.BadRequestException;
import io.scalecube.services.exceptions.ForbiddenException;
import io.scalecube.services.exceptions.InternalServiceException;
import io.scalecube.services.exceptions.ServiceClientErrorMapper;
import io.scalecube.services.exceptions.ServiceException;
import io.scalecube.services.exceptions.ServiceProviderErrorMapper;
import io.scalecube.services.exceptions.ServiceUnavailableException;
import io.scalecube.services.exceptions.UnauthorizedException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import org.jetlinks.core.utils.ExceptionUtils;
import org.springframework.util.StringUtils;

public class DetailErrorMapper
implements ServiceClientErrorMapper,
ServiceProviderErrorMapper {
    static final FastThreadLocal<ByteArrayOutputStream> SHARED_OUT = new FastThreadLocal<ByteArrayOutputStream>(){

        protected ByteArrayOutputStream initialValue() {
            return new ByteArrayOutputStream(1024);
        }
    };
    private static final int DEFAULT_ERROR_CODE = 500;
    public static final DetailErrorMapper INSTANCE = new DetailErrorMapper();
    public static final String ERROR_DETAIL = "errorDetail";
    StackTraceElement[] topTrace = new StackTraceElement[0];

    void setTopTrace(StackTraceElement ... trace) {
        this.topTrace = trace;
    }

    public Throwable toError(ServiceMessage message) {
        BadRequestException error;
        ErrorData data = (ErrorData)message.data();
        int errorType = message.errorType();
        int errorCode = data.getErrorCode();
        String errorMessage = data.getErrorMessage();
        StackTraceElement[] stackTrace = DetailErrorMapper.decodeDetail(message.header(ERROR_DETAIL), this.topTrace);
        switch (errorType) {
            case 400: {
                error = new BadRequestException(errorCode, errorMessage);
                break;
            }
            case 401: {
                error = new UnauthorizedException(errorCode, errorMessage);
                break;
            }
            case 403: {
                error = new ForbiddenException(errorCode, errorMessage);
                break;
            }
            case 503: {
                error = new ServiceUnavailableException(errorCode, errorMessage);
                break;
            }
            case 500: {
                error = new InternalServiceException(errorCode, errorMessage);
                break;
            }
            default: {
                error = new InternalServiceException(errorCode, errorMessage);
            }
        }
        if (stackTrace != null) {
            error.setStackTrace(stackTrace);
        }
        return error;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static StackTraceElement[] decodeDetail(String e, StackTraceElement ... top) {
        if (!StringUtils.hasText((String)e)) {
            return null;
        }
        try (DataInputStream input = new DataInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(e)));){
            int length = input.readInt();
            StackTraceElement[] stack = Arrays.copyOf(top, top.length + length);
            for (int i = top.length; i < length + top.length; ++i) {
                String className = input.readUTF();
                String methodName = input.readUTF();
                String fileName = input.readUTF();
                int lineNumber = input.readInt();
                stack[i] = new StackTraceElement(className, methodName, StringUtils.hasText((String)fileName) ? fileName : null, lineNumber);
            }
            StackTraceElement[] stackTraceElementArray = stack;
            return stackTraceElementArray;
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     * Loose catch block
     */
    public static String createDetail(StackTraceElement[] top, Throwable e) {
        StackTraceElement[] stack = ExceptionUtils.getMergedStackTrace((Throwable)e);
        if (stack.length == 0) {
            return "";
        }
        ByteArrayOutputStream out = (ByteArrayOutputStream)SHARED_OUT.get();
        try {
            Object object;
            Object object2;
            DataOutputStream dataOut;
            block20: {
                block21: {
                    dataOut = new DataOutputStream(out);
                    object2 = null;
                    dataOut.writeInt(stack.length + top.length);
                    for (StackTraceElement element : top) {
                        dataOut.writeUTF(element.getClassName());
                        dataOut.writeUTF(element.getMethodName());
                        dataOut.writeUTF(element.getFileName() == null ? "" : element.getFileName());
                        dataOut.writeInt(element.getLineNumber());
                    }
                    for (StackTraceElement element : stack) {
                        dataOut.writeUTF(element.getClassName());
                        dataOut.writeUTF(element.getMethodName());
                        dataOut.writeUTF(element.getFileName() == null ? "" : element.getFileName());
                        dataOut.writeInt(element.getLineNumber());
                    }
                    object = Base64.getEncoder().encodeToString(out.toByteArray());
                    if (dataOut == null) break block20;
                    if (object2 == null) break block21;
                    try {
                        dataOut.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                    break block20;
                }
                dataOut.close();
            }
            return object;
            catch (Throwable throwable) {
                try {
                    try {
                        object2 = throwable;
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        if (dataOut != null) {
                            if (object2 != null) {
                                try {
                                    dataOut.close();
                                }
                                catch (Throwable throwable3) {
                                    ((Throwable)object2).addSuppressed(throwable3);
                                }
                            } else {
                                dataOut.close();
                            }
                        }
                        throw throwable2;
                    }
                }
                catch (Throwable ignore) {
                    object2 = "";
                    return object2;
                }
            }
        }
        finally {
            out.reset();
        }
    }

    public ServiceMessage toMessage(String qualifier, Throwable throwable) {
        int errorCode = 500;
        int errorType = 500;
        if (throwable instanceof ServiceException) {
            errorCode = ((ServiceException)throwable).errorCode();
            if (throwable instanceof BadRequestException) {
                errorType = 400;
            } else if (throwable instanceof UnauthorizedException) {
                errorType = 401;
            } else if (throwable instanceof ForbiddenException) {
                errorType = 403;
            } else if (throwable instanceof ServiceUnavailableException) {
                errorType = 503;
            }
        }
        String errorMessage = Optional.ofNullable(throwable.getMessage()).orElseGet(throwable::toString);
        return ServiceMessage.builder().qualifier(qualifier).header("errorType", String.valueOf(errorType)).header(ERROR_DETAIL, DetailErrorMapper.createDetail(this.topTrace, throwable)).data((Object)new ErrorData(errorCode, errorMessage)).build();
    }
}

