/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.supports.protocol.blocking;

import java.time.Duration;
import java.util.Collection;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetlinks.core.defaults.BlockingDeviceOperator;
import org.jetlinks.core.message.DeviceMessage;
import org.jetlinks.core.message.codec.EncodedMessage;
import org.jetlinks.core.message.codec.MessageEncodeContext;
import org.jetlinks.core.message.codec.ToDeviceMessageContext;
import org.jetlinks.core.monitor.Monitor;
import org.jetlinks.core.server.session.DeviceSession;
import org.jetlinks.supports.protocol.blocking.BlockingMessageCodecContext;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.util.context.ContextView;

public class BlockingMessageEncodeContext
extends BlockingMessageCodecContext<MessageEncodeContext> {
    public BlockingMessageEncodeContext(Monitor monitor, MessageEncodeContext context, Duration timeout, ContextView ctx) {
        super(monitor, context, timeout, ctx);
    }

    @Override
    @Nonnull
    public BlockingDeviceOperator getDevice() {
        return super.getDevice();
    }

    @Override
    @Nullable
    public BlockingDeviceOperator getDevice(String deviceId) {
        return super.getDevice(deviceId);
    }

    public DeviceMessage getMessage() {
        return (DeviceMessage)((MessageEncodeContext)this.context).getMessage();
    }

    public DeviceSession getSession() {
        return ((ToDeviceMessageContext)((MessageEncodeContext)this.context).unwrap(ToDeviceMessageContext.class)).getSession();
    }

    public DeviceSession getSession(String deviceId) {
        return (DeviceSession)this.await(((ToDeviceMessageContext)((MessageEncodeContext)this.context).unwrap(ToDeviceMessageContext.class)).getSession(deviceId));
    }

    public boolean sessionIsAlive(String deviceId) {
        return (Boolean)this.await(((ToDeviceMessageContext)((MessageEncodeContext)this.context).unwrap(ToDeviceMessageContext.class)).sessionIsAlive(deviceId));
    }

    public void disconnect() {
        this.await(((ToDeviceMessageContext)((MessageEncodeContext)this.context).unwrap(ToDeviceMessageContext.class)).disconnect());
    }

    public void sendToDeviceNow(EncodedMessage message) {
        this.await(((ToDeviceMessageContext)((MessageEncodeContext)this.context).unwrap(ToDeviceMessageContext.class)).sendToDevice(message));
    }

    public void sendToDeviceLater(EncodedMessage message) {
        this.async(((ToDeviceMessageContext)((MessageEncodeContext)this.context).unwrap(ToDeviceMessageContext.class)).sendToDevice(message));
    }

    public Mono<Void> sendToDeviceReactive(EncodedMessage message) {
        return ((ToDeviceMessageContext)((MessageEncodeContext)this.context).unwrap(ToDeviceMessageContext.class)).sendToDevice(message).then();
    }

    public void sendToPlatformLater(Collection<? extends DeviceMessage> message) {
        this.async(((MessageEncodeContext)this.context).reply(message));
    }

    public void sendToPlatformLater(Publisher<? extends DeviceMessage> message) {
        this.async(((MessageEncodeContext)this.context).reply(message));
    }

    public void sendToPlatformLater(DeviceMessage message) {
        this.async(((MessageEncodeContext)this.context).reply(new DeviceMessage[]{message}));
    }

    public Mono<Void> sendToPlatformReactive(DeviceMessage message) {
        return ((MessageEncodeContext)this.context).reply(new DeviceMessage[]{message});
    }

    public void sendToPlatformNow(Collection<? extends DeviceMessage> message) {
        this.await(((MessageEncodeContext)this.context).reply(message));
    }

    public void sendToPlatformNow(DeviceMessage message) {
        this.await(((MessageEncodeContext)this.context).reply(new DeviceMessage[]{message}));
    }
}

