/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;
import org.jetlinks.core.utils.SerializeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.util.LinkedMultiValueMap;

class TypedMapSerializer
implements SerializeUtils.Serializer {
    private static final Logger log = LoggerFactory.getLogger(TypedMapSerializer.class);
    public static final int CODE = 33;

    TypedMapSerializer() {
    }

    @Override
    public int getCode() {
        return 33;
    }

    @Override
    public Class<?> getJavaType() {
        return Map.class;
    }

    @Override
    public Object deserialize(ObjectInput input) {
        byte type = input.readByte();
        if (type == -1) {
            Map instance;
            String name = input.readUTF();
            try {
                Class tClass = SerializeUtils.getClass(name);
                instance = (Map)tClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable e) {
                log.warn("can not create instance for class:{}", (Object)name, (Object)e);
                instance = Maps.newHashMap();
            }
            HashMap fInstance = instance;
            SerializeUtils.readMap(input, i -> fInstance);
            return instance;
        }
        if (type == -2) {
            return input.readObject();
        }
        return SerializeUtils.readMap(input, MapType.VALUES[type].instance);
    }

    @Override
    public void serialize(Object value, ObjectOutput input) {
        Map map = (Map)value;
        Class<?> clazz = value.getClass();
        MapType type = MapType.findOrNull(clazz);
        if (type == null) {
            if (map instanceof Serializable) {
                input.writeByte(-2);
                input.writeObject(map);
                return;
            }
            input.writeByte(-1);
            input.writeUTF(clazz.getName());
        } else {
            input.writeByte(type.ordinal());
        }
        SerializeUtils.writeKeyValue(map, input);
    }

    static enum MapType {
        hashMap(Maps::newHashMapWithExpectedSize, HashMap.class),
        linkedHashMap(Maps::newLinkedHashMapWithExpectedSize, LinkedHashMap.class),
        concurrentHashMap(ConcurrentHashMap::new, ConcurrentHashMap.class),
        identityHashMap(IdentityHashMap::new, IdentityHashMap.class),
        treeMap(ignore -> new TreeMap(), TreeMap.class),
        concurrentSkipListMap(ignore -> new ConcurrentSkipListMap(), ConcurrentSkipListMap.class),
        hashTable(ignore -> new Hashtable(), Hashtable.class),
        httpHeaders(ignore -> new HttpHeaders(), HttpHeaders.class),
        multiValueMap(ignore -> new LinkedMultiValueMap(), LinkedMultiValueMap.class),
        fastJson(ignore -> new JSONObject(), JSONObject.class);

        private final Function<Integer, Map<?, ?>> instance;
        private final Class<?> clazz;
        private static final MapType[] VALUES;

        static MapType findOrNull(Class<?> clazz) {
            for (MapType value : VALUES) {
                if (value.clazz != clazz) continue;
                return value;
            }
            String clazzName = clazz.getName();
            if (clazzName.startsWith("java.util.Collections") || clazzName.startsWith("com.google")) {
                return hashMap;
            }
            if (HttpHeaders.class.isAssignableFrom(clazz)) {
                return httpHeaders;
            }
            return null;
        }

        private MapType(Function<Integer, Map<?, ?>> instance, Class<?> clazz) {
            this.instance = instance;
            this.clazz = clazz;
        }

        static {
            VALUES = MapType.values();
        }
    }
}

