/*
 * Decompiled with CFR 0.152.
 */
package org.jetlinks.core.utils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.jetlinks.core.metadata.DataType;
import org.jetlinks.core.metadata.EventMetadata;
import org.jetlinks.core.metadata.PropertyMetadata;
import org.jetlinks.core.metadata.types.ArrayType;
import org.jetlinks.core.metadata.types.DateTimeType;
import org.jetlinks.core.metadata.types.EnumType;
import org.jetlinks.core.metadata.types.GeoType;
import org.jetlinks.core.metadata.types.NumberType;
import org.jetlinks.core.metadata.types.ObjectType;
import org.jetlinks.core.metadata.types.StringType;
import org.jetlinks.core.things.ThingMetadata;
import org.springframework.core.io.ClassPathResource;

public class TypeScriptUtils {
    public static StringBuilder declareClass(String name, String comment, List<PropertyMetadata> properties, StringBuilder main) {
        ArrayList<String> declares = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        TypeScriptUtils.declareClass(name, comment, properties, builder, declares);
        for (String declare : declares) {
            main.append(declare);
        }
        main.append((CharSequence)builder);
        return main;
    }

    public static void createMetadataDeclare(ThingMetadata metadata, StringBuilder main) {
        List<PropertyMetadata> properties = metadata.getProperties();
        List<EventMetadata> events = metadata.getEvents();
        ArrayList<String> declares = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(properties)) {
            TypeScriptUtils.declareClass("PropertyMetadata", "\u7269\u6a21\u578b\u5c5e\u6027", properties, builder, declares);
        }
        for (String declare : declares) {
            main.append(declare);
        }
        main.append((CharSequence)builder);
    }

    public static void createMetadataVar(ThingMetadata metadata, StringBuilder main) {
        List<PropertyMetadata> properties = metadata.getProperties();
        ArrayList<String> declares = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        if (CollectionUtils.isNotEmpty(properties)) {
            TypeScriptUtils.declareVar(properties, builder, declares);
        }
        for (String declare : declares) {
            main.append(declare);
        }
        main.append((CharSequence)builder);
    }

    public static void declareVar(List<PropertyMetadata> properties, StringBuilder builder, List<String> declares) {
        for (PropertyMetadata property : properties) {
            String id = property.getId();
            if (id.contains("-")) continue;
            String comment = property.getName();
            if (property.getDescription() != null) {
                comment = comment + "\n" + property.getDescription();
            }
            TypeScriptUtils.appendComments(builder, property.getValueType(), comment);
            builder.append("declare var ").append(id).append(":").append(TypeScriptUtils.convertType(id, property.getValueType(), declares)).append(";").append("\n");
        }
    }

    public static void declareClass(String name, String comment, List<PropertyMetadata> properties, StringBuilder builder, Collection<String> declares) {
        TypeScriptUtils.appendComments(builder, comment);
        builder.append("declare class ").append(name).append("{\n");
        for (PropertyMetadata property : properties) {
            String id = property.getId();
            if (id.contains("-")) continue;
            TypeScriptUtils.appendComments(builder, property.getValueType(), property.getName());
            builder.append("declare ");
            builder.append(id).append(":").append(TypeScriptUtils.convertType(name + "_" + id, property.getValueType(), declares)).append(";").append("\n");
        }
        builder.append("\n}\n");
    }

    private static void declareClassAsMap(List<PropertyMetadata> properties, StringBuilder builder, Collection<String> declares) {
        builder.append("{\n");
        for (PropertyMetadata property : properties) {
            String id = property.getId();
            if (id.contains("-")) continue;
            TypeScriptUtils.appendComments(builder, property.getValueType(), property.getName());
            builder.append(id).append(":").append(TypeScriptUtils.convertType(id, property.getValueType(), declares)).append(",").append("\n");
        }
        builder.append("\n}\n");
    }

    public static String convertType(String owner, DataType type, Collection<String> declares) {
        if (type == null) {
            return "object";
        }
        if (type instanceof StringType) {
            return "string";
        }
        if (type instanceof NumberType) {
            return type.getId();
        }
        if (type instanceof DateTimeType) {
            return "long";
        }
        if (type instanceof ArrayType) {
            return "java.util.List<" + TypeScriptUtils.convertType(owner + "_Element", ((ArrayType)type).getElementType(), declares) + ">";
        }
        if (type instanceof GeoType) {
            return "org.jetlinks.metadata.types.GeoPoint";
        }
        if (type instanceof EnumType) {
            return ((EnumType)type).getElements().stream().map(EnumType.Element::getValue).collect(Collectors.joining("'|'", "'", "'"));
        }
        if (type instanceof ObjectType) {
            ObjectType objectType = (ObjectType)type;
            StringBuilder builder = new StringBuilder();
            TypeScriptUtils.declareClassAsMap(objectType.getProperties(), builder, declares);
            return builder.toString();
        }
        return "object";
    }

    private static void appendComments(StringBuilder builder, DataType type, String comments) {
        builder.append("/**\n");
        builder.append("* ").append(comments == null ? "" : comments.replace("\n", "\n* ")).append("\n*");
        if (type instanceof EnumType) {
            for (EnumType.Element element : ((EnumType)type).getElements()) {
                builder.append("\n* ").append(element.getValue()).append(" :").append(element.getText()).append("\n");
                builder.append("*");
            }
        }
        builder.append("*/\n");
    }

    private static void appendComments(StringBuilder builder, String comments) {
        builder.append("/**\n");
        builder.append("* ").append(comments == null ? "" : comments).append("\n");
        builder.append("*/\n");
    }

    public static String loadDeclare(String name) {
        StringBuilder builder = new StringBuilder();
        TypeScriptUtils.loadDeclare(name, builder, new LinkedHashSet<String>());
        return builder.toString();
    }

    public static void loadDeclare(String name, StringBuilder builder) {
        TypeScriptUtils.loadDeclare(name, builder, new LinkedHashSet<String>());
    }

    private static void loadDeclare(String name, StringBuilder builder, Set<String> imports) {
        if (imports.contains(name)) {
            return;
        }
        try (InputStream stream = new ClassPathResource("typescript/" + name + ".d.ts").getInputStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(stream));){
            while (reader.ready()) {
                String line = reader.readLine();
                if (line.contains("@ts-ignore")) continue;
                if (line.startsWith("import")) {
                    int index = line.lastIndexOf("from ");
                    if (index <= 0) continue;
                    String module = line.substring(line.lastIndexOf("from ") + 5).trim().replace("\"", "").replace("'", "").replace(";", "");
                    TypeScriptUtils.loadDeclare(module, builder, imports);
                    imports.add(module);
                    continue;
                }
                builder.append(line).append("\n");
            }
        }
    }
}

